package ch.sahits.game.graphic.display.dialog;

import java.util.HashMap;

import org.apache.log4j.Logger;

import ch.sahits.game.openpatrician.model.product.IWare;

/**
 * This proxy handles the execution of the sell action based on the current
 * type of the dialog.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 18, 2011
 *
 */
class SellProxyAction implements Runnable {
	private static final Logger logger = Logger.getLogger(SellProxyAction.class);
	private final ITransferable dialog;
	private final HashMap<ETransferDialogType, Runnable> actionMap;
	

	public SellProxyAction(IWare ware, ITransferable dialog) {
		super();
		this.dialog = dialog;
		actionMap = new HashMap<ETransferDialogType, Runnable>();
		actionMap.put(ETransferDialogType.CITY_TO_SHIP, new Ship2CityAction(ware, dialog));
		actionMap.put(ETransferDialogType.CITY_TO_STORAGE, new Storage2CityAction(ware,dialog));
		actionMap.put(ETransferDialogType.STORAGE_TO_SHIP, new Storage2ShipAction(ware,dialog));
	}

	/**
	 * Delegate to the run method of the action associated with the dialog type
	 */
	@Override
	public void run() {
		Runnable action = actionMap.get(dialog.getDialogType());
		if (action==null){
			logger.error("No action defined for dialog transfer type: "+dialog.getDialogType());
		} else {
			action.run();
		}
	}

}
