package ch.sahits.game.graphic.display.dialog;


import ch.sahits.game.graphic.display.model.ICityPlayerProxy;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IShip;

/**
 * This action handles the transfer of wares from the storage to the ship.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 24, 2011
 *
 */
public class Storage2ShipAction implements Runnable {
	private final IWare ware;
	private final ITransferable dialog;
//	private static final Logger logger = Logger.getLogger(Storage2ShipAction.class.getName());

	public Storage2ShipAction(IWare ware, ITransferable dialog) {
		super();
		this.ware = ware;
		this.dialog=dialog;
	}

	@Override
	public void run() {
		ICityPlayerProxy city = dialog.getCityPlayerProxy();
		IShip ship = city.getActiveShip();
		ITradingOffice office = city.getPlayer().findTradingOffice(city.getCity());
		int availableAmountStorage = office.getWare(ware).getAmount();
		if (availableAmountStorage>0 && office!=null){
			int amount2Move = dialog.getAmount(availableAmountStorage); // This is ware specific size
			int avgPrice = office.getWare(ware).getAVGPrice();
			int moved = office.move(ware, -amount2Move,avgPrice);
			ship.load(ware, moved, avgPrice);
		}
	}
	
}
