package ch.sahits.game.graphic.display.dialog;

import java.awt.Color;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.io.IOException;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.Event;
import ch.sahits.game.event.IEventListener;
import ch.sahits.game.event.KeyPressEvent;
import ch.sahits.game.event.MouseClickEvent;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.gameplay.MainView;
import ch.sahits.game.graphic.display.model.CityPlayerProxy;
import ch.sahits.game.graphic.display.notice.NoticeView;
import ch.sahits.game.graphic.display.util.ClickablePolygons;
import ch.sahits.game.graphic.image.DisplayImageDIResolver;
import ch.sahits.game.graphic.image.IImageLoader;
import ch.sahits.game.graphic.image.IOpenPatricianPainter;
import ch.sahits.game.graphic.image.model.NamedPolygon;
import ch.sahits.game.image.IImageUtilities;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.EMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.personal.IMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.time.DateObject;
import ch.sahits.game.rendering.RenderablePart;

public class TradingOfficePersonalDialog extends OpenPatricianGameDialog implements IEventListener, RenderablePart{
	/** reference to the utilities for image manipulation */
	private IImageUtilities imageUtils;
	private IOpenPatricianPainter opPainter;
	private boolean enabled = true;
	private ClickablePolygons footerPolygons;
	/** Hold all the positioning information, initialized in initBackgroundImage */
	private DialogPositions positions;
	
	public TradingOfficePersonalDialog(Point topLeft, double scale,
			CityPlayerProxy cityProxy) {
		super(topLeft, DisplayImageDIResolver.getInstance().getMainScreenLoader(), scale, cityProxy);
		Event.add(this);
	}
	@Override
	protected void init() {
		DisplayImageDIResolver resolver = DisplayImageDIResolver.getInstance();
		opPainter = resolver.getOpenPatricianPainter();
		imageUtils = resolver.getImageUtilities();
		super.init();
	}
	@Override
	protected void initiatePolygons() {
		footerPolygons = new ClickablePolygons();
	}
	@Override
	public boolean isEnabled() {
		return enabled;
	}

	@Override
	public void setEnabled(boolean flag) {
		enabled=flag;
	}
	@Override
	public void gameUpdate(Event e, Object notice) {
		if (e instanceof KeyPressEvent){
			KeyEvent key= ((KeyPressEvent)e).getKey();
			if (key.getKeyCode()==KeyEvent.VK_ESCAPE){
				new ViewChangeEvent(MainView.class).notify(EViewChangeEvent.CLOSE_DIALOG);
				new ViewChangeEvent(NoticeView.class).notify(EViewChangeEvent.NOTICE_HIDE);
				Event.remove(this);
			}
		}
		if (e instanceof MouseClickEvent){
			footerPolygons.testAndExecute((Point) notice);
		}
	}
	@Override
	protected BufferedImage initBackgroundImage(IImageLoader loader,Point topLeft) {
		BufferedImage bg = super.initBackgroundImage(loader,topLeft);
		Graphics2D g2d = bg.createGraphics();
		g2d.setColor(Color.BLACK);
		try {
			GlyphVector gv = opPainter.createGlyphVector(g2d, "Personal", 24); // TODO externalize
			double titleHeight = gv.getVisualBounds().getHeight();
			int length = (int) Math.rint(gv.getVisualBounds().getWidth());
			int x = ((bg.getWidth()-getInset().left-getInset().right)-length)/2;
			int y = getInset().top+10+(int)Math.rint(titleHeight*2/3);
			g2d.drawGlyphVector(gv, x, y);
			// Dynamic row
			y += titleHeight;
			y += (int)Math.rint(titleHeight*2/3);
			
			BufferedImage waxSeal = loader.getImage("waxseal");
			int yLineDiff = waxSeal.getHeight();
			int leftBorderX = topLeft.x+getInset().left;
			int firstColumn = leftBorderX+20; // right aligned
			int xPortrait = leftBorderX+200;
			int yPortrait = y+yLineDiff*10;
			// Initialize the position relative to the frame
			positions = new DialogPositions( yLineDiff, xPortrait,yPortrait);
			
			leftBorderX = getInset().left; // Use local coordinates
			firstColumn = leftBorderX+20; // right aligned
			
			// table header
			IPlayer player = city.getPlayer();
			IPersonalData data = player.getPersonalData();
			y += positions.lineHeight; // more space to the title
			
			// Name
			y = drawRow(g2d, y, firstColumn, "Name");
			StringBuilder sb = new StringBuilder();
			sb.append(data.getName()).append(" ").append(data.getLastName());
			ESocialRank rank = player.getRank();
			sb.append(" (").append(player.getCareerLevel()).append(" ").append(rank).append(")"); // TODO externalize
			y = drawRow(g2d, y, firstColumn, sb.toString());
			
			y += positions.lineHeight;
			
			// Birth
			DateObject now = new DateObject(Date.getInstance(0).getCurrentDate()); // TODO ugly
			y = drawRow(g2d, y, firstColumn, "Born");
			sb = new StringBuilder();
			ICity birthPlace = data.getBirthPlace();
			sb.append("on ").append(data.getBirthDate().toDisplayString()).append(" in ").append(birthPlace.getName()).append(", ");
			sb.append("Age ").append(data.getAge(now));
			y = drawRow(g2d, y, firstColumn, sb.toString());

			y += positions.lineHeight;

			y = drawRow(g2d, y, firstColumn, "Hometown");
			y = drawRow(g2d, y, firstColumn, player.getHometown().getName());
			
			y += positions.lineHeight;
			sb = new StringBuilder();
			sb.append("Social status in this town: ").append(city.getCity().getSocialRank());
			y = drawRow(g2d, y, firstColumn, sb.toString());
			
			IReputation rep = city.getCity().getReputation(player);
			int repDiff = rep.getReputationDifference();
			sb = new StringBuilder();
			if (repDiff<0){
				// reputation has sunk
				if (repDiff<=-10 && repDiff>-25){
					sb.append("Your reputation has sunken.");
				} else if (repDiff>-10){
					sb.append("Your reputation has sunken slightly");
				} else {
					sb.append("Your reputation has dropped");
				}
			} else if (repDiff>0){
				// reputation has risen
				if (repDiff>=10 && repDiff<25){
					sb.append("Your reputation has risen");
				} else if (repDiff<10){
					sb.append("Your reputation has risen slightly");
				} else {
					sb.append("Your reputation has risen massivly");
				}
			} else {
				sb.append("Your reputation in this city is unchanged");
			}
			y = drawRow(g2d, y, firstColumn, sb.toString());
			
			if (rank!=ESocialRank.ALDERMAN && rank!=ESocialRank.MAYOR){
				// draw string what is needed
				ESocialRank nextRank = rank.getNextRank();
				boolean needFortune = false;
				if (player.getCompany().getCompanyValue()<nextRank.getCompanyValue()){
					needFortune=true;
				}
				boolean needReputation=false;
				if (city.getCity().getReputation(player).getPopularity()<nextRank.getSocialReputation()){
					needReputation=true;
				}
				sb = new StringBuilder();
				if (needFortune && needReputation){
					sb.append("You need more fortune and respect in ").append(city.getCity().getName()).append(" to");
					y = drawRow(g2d, y, firstColumn, sb.toString());
					sb = new StringBuilder();
					sb.append("advanve to the next social rank");
					y = drawRow(g2d, y, firstColumn, sb.toString());
				} else if (needFortune){
					sb.append("You need more fortune in ").append(city.getCity().getName()).append(" to");
					y = drawRow(g2d, y, firstColumn, sb.toString());
					sb = new StringBuilder();
					sb.append("advanve to the next social rank");
					y = drawRow(g2d, y, firstColumn, sb.toString());
				} else if (needReputation){
					sb.append("You need more respect in ").append(city.getCity().getName()).append(" to");
					y = drawRow(g2d, y, firstColumn, sb.toString());
					sb = new StringBuilder();
					sb.append("advanve to the next social rank");
					y = drawRow(g2d, y, firstColumn, sb.toString());
				} else {
					y += positions.lineHeight;
					y += positions.lineHeight;
				}
			} else {
				y += positions.lineHeight;
				y += positions.lineHeight;
			}
			
			// Draw underworld string
			ICareer careerLevel = player.getCareerLevel();
			String s;
			if (careerLevel instanceof IMilitantCareer){
				if (((EMilitantCareer)careerLevel)!=EMilitantCareer.BOISTEROUS &&
					((EMilitantCareer)careerLevel)!=EMilitantCareer.BOLD ){
					s = "The underworld fears you";
				} else {
					s = "The underworld avoids you";
				}
			} else {
				s = "The underworld avoids you";
			}
			y = drawRow(g2d, y, firstColumn, s);
			y += positions.lineHeight;
			
			if (player.getSpouseData()!=null){
				ISpouseData spouse = player.getSpouseData();
				// Name
				if (spouse.isMale()){
					s = "Name of husband"; // TODO externalize
				} else {
					s = "Name of wife";
				}
				y = drawRow(g2d, y, firstColumn, s);
				sb = new StringBuilder();
				sb.append(spouse.getName()).append(" ").append(spouse.getLastName());
				sb.append(", Age ").append(spouse.getAge(now));
				y = drawRow(g2d, y, firstColumn, sb.toString());
				
				y += positions.lineHeight;
				
				// Birth
				y = drawRow(g2d, y, firstColumn, "Born");
				sb = new StringBuilder();
				sb.append("on ").append(data.getBirthDate().toDisplayString()).append(" in ").append(birthPlace.getName());
				y = drawRow(g2d, y, firstColumn, sb.toString());

				y += positions.lineHeight;

				y = drawRow(g2d, y, firstColumn, "Children");
				y = drawRow(g2d, y, firstColumn, String.valueOf(spouse.getNumberOfChildren()));
				
				y += positions.lineHeight;

				sb = new StringBuilder();
				if (city.getCity()==birthPlace){
					// TODO consider the spouses popularity and relations
					if (spouse.isMale()){
						sb.append("Your husband is unknown to the citizens of ").append(city.getCity().getName());
					} else {
						sb.append("Your wife is unknown to the citizens of ").append(city.getCity().getName());
					}
					y = drawRow(g2d, y, firstColumn, sb.toString());
					sb = new StringBuilder();
					y = drawRow(g2d, y, firstColumn, sb.toString());
					sb.append("and has no relations with the counsilmen.");
				} else if (city.getCity()==player.getCompany().getHomeTown()){
					// TODO consider the spouses popularity and relations
					if (spouse.isMale()){
						sb.append("Your husband is unknown to the citizens of ").append(city.getCity().getName());
					} else {
						sb.append("Your wife is unknown to the citizens of ").append(city.getCity().getName());
					}
					y = drawRow(g2d, y, firstColumn, sb.toString());
					sb = new StringBuilder();
					y = drawRow(g2d, y, firstColumn, sb.toString());
					sb.append("and has no relations with the counsilmen.");
				} else {
					if (spouse.isMale()){
						sb.append("Your husband is unknown to the citizens of ").append(city.getCity().getName());
					} else {
						sb.append("Your wife is unknown to the citizens of ").append(city.getCity().getName());
					}
					y = drawRow(g2d, y, firstColumn, sb.toString());
					sb = new StringBuilder();
					y = drawRow(g2d, y, firstColumn, sb.toString());
					sb.append("and has no relations with the counsilmen.");
				}
				if (spouse.getPortrait()!=null){
					g2d.drawImage(spouse.getPortrait(), positions.xPortrait,  positions.yPortrait, null);
				}
			}

			// Footer buttons
			y = bg.getHeight()-getInset().bottom-positions.lineHeight;
			x = getInset().left+30;
			int footerWidth = bg.getWidth()-getInset().left-getInset().right-2*30;
			x += 3*footerWidth/4;
			// close
			g2d.drawImage(waxSeal, x,y-(int)(positions.lineHeight*0.8), null);
			NamedPolygon polygon = new NamedPolygon("Close");
			polygon.addPoint(topLeft.x+x, topLeft.y+y-(int)(positions.lineHeight*0.8));
			polygon.addPoint(topLeft.x+x+waxSeal.getWidth(), topLeft.y+y-(int)(positions.lineHeight*0.8));
			polygon.addPoint(topLeft.x+x+waxSeal.getWidth(), topLeft.y+y-(int)(positions.lineHeight*0.8)+waxSeal.getHeight());
			polygon.addPoint(topLeft.x+x, topLeft.y+y-(int)(positions.lineHeight*0.8)+waxSeal.getHeight());
			footerPolygons.add(polygon, new CloseAction(this));
			g2d.setColor(new Color(0xEA,0xC1,0x17)); // Gold
			gv = opPainter.createGlyphVector(g2d, "X", 18);
			int xPadding = imageUtils.computeCenterAlignX(x, waxSeal.getWidth(), (int)gv.getVisualBounds().getWidth());
			g2d.drawGlyphVector(gv, xPadding, y); // centeralign


		} catch (FontFormatException e1) {
			e1.printStackTrace();
		} catch (IOException e1) {
			e1.printStackTrace();
		}
		return bg;
	}
	/**
	 * Draw a text string at a defined position. The Y-position is passed as an argument, updated for the next row
	 * and returned. The X-coordinate is computed from the left border argument and the visual length of the text string
	 * @param g2d Graphic context
	 * @param y position
	 * @param leftBorder left inset
	 * @param text to be drawn
	 * @return updated y coordinate
	 * @throws FontFormatException
	 * @throws IOException
	 */
	private int drawRow(Graphics2D g2d, int y,int leftBorder, String text) throws FontFormatException, IOException{
		y += positions.lineHeight;
		GlyphVector gv = opPainter.createGlyphVector(g2d, text, 18);
		int x = leftBorder;
		g2d.drawGlyphVector(gv, x, y);
		return y;
	}

	
	/**
	 * This class holds the positions where different elements are
	 * placed on the dialog.
	 * @author Andi Hotz, (c) Sahits GmbH, 2011
	 * Created on Dec 9, 2011
	 *
	 */
	private static class DialogPositions{
		private final int lineHeight;
		private final int xPortrait;
		private final int yPortrait;
		public DialogPositions(int lineHeight,
				int xPortrait, int yPortrait) {
			super();
			this.lineHeight = lineHeight;
			this.xPortrait = xPortrait;
			this.yPortrait = yPortrait;
		}
		
	}
}
