package ch.sahits.game.graphic.display.gameplay;

import java.awt.Color;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.text.NumberFormat;

import ch.sahits.game.event.Event;
import ch.sahits.game.event.IEventListener;
import ch.sahits.game.event.PlayerChangeEvent;
import ch.sahits.game.event.TimeChangeEvent;
import ch.sahits.game.graphic.image.DisplayImageDIResolver;
import ch.sahits.game.graphic.image.IOpenPatricianPainter;
import ch.sahits.game.openpatrician.client.IClient;
import ch.sahits.game.openpatrician.model.EPlayerStateChange;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import ch.sahits.game.rendering.AbstractRenderPart;
/**
 * This view represents the game status such as date and money.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 30, 2011
 *
 */
public class GameStatus extends AbstractRenderPart implements IEventListener {
	
	private final IClient client;
	private String cash;
	private String date;
	private final IOpenPatricianPainter opPainter;

	public GameStatus(Rectangle rect,IClient client) {
		super(rect);
		this.client = client;
		opPainter = DisplayImageDIResolver.getInstance().getOpenPatricianPainter();
		gameUpdate(new TimeChangeEvent(), null);
		gameUpdate(new PlayerChangeEvent(), EPlayerStateChange.MONEY);
		Event.add(this);
	}

	@Override
	public void gameRender(Graphics gScr) {
		Color oldColor = gScr.getColor();
//		gScr.setColor(Color.PINK);
//		gScr.fillRect(rect.x, rect.y, rect.width, rect.height);
		gScr.setColor(Color.WHITE);
		int x = 20+rect.x;
		final int y = rect.y+rect.height/2;
		try {
			GlyphVector gv = opPainter.createGlyphVector((Graphics2D) gScr, cash, 18);
			((Graphics2D)gScr).drawGlyphVector(gv, x, y);
			gv = opPainter.createGlyphVector((Graphics2D) gScr, date, 18);
			Rectangle2D b = gv.getVisualBounds();
			x = (int) (rect.x+rect.width-20-b.getWidth());
			((Graphics2D)gScr).drawGlyphVector(gv, x, y);
		} catch (FontFormatException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
//		gScr.drawString("GameStatus", x, y);
		gScr.setColor(oldColor);
		// TODO Auto-generated method stub

	}

	@Override
	public void gameUpdate(Event e, Object eventNotice) {
		if (e instanceof TimeChangeEvent){
			date = client.getGame().getTime().toDisplayString();
			// set flag for date change animation
		}
		if (e instanceof PlayerChangeEvent){
			if (eventNotice==EPlayerStateChange.MONEY){
				String money = NumberFormat.getInstance(Locale.getInstance().getCurrentLocal()).format(client.getPlayer().getCash());
				cash = String.valueOf(money);
				// set flag for cash change animation
			}
		}
	}

}
