package ch.sahits.game.graphic.display.gameplay;

import java.awt.image.BufferedImage;

import ch.sahits.game.graphic.display.dialog.OpenPatricianGameDialog;

/**
 * Interface that is used as an inner class to update a dialog instance
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 17, 2012
 *
 */
public interface IUpdatableDialog {
	/**
	 * Pass the dialog with that should be updated
	 * @param dialog
	 */
	public void updateDialog(OpenPatricianGameDialog dialog);
	/**
	 * Retrieve the fringe of the dialog
	 * @return
	 */
	public BufferedImage getDialogFringe();
}
