package ch.sahits.game.graphic.display.gameplay;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

import ch.sahits.game.event.Event;
import ch.sahits.game.event.IEventListener;
import ch.sahits.game.graphic.image.DisplayImageDIResolver;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.IOpenPatricianPainter;
import ch.sahits.game.openpatrician.client.IClient;
import ch.sahits.game.rendering.AbstractRenderPart;
/**
 * This view represents the status view of the main view
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 30, 2011
 *
 */
public class ViewStatus extends AbstractRenderPart implements IEventListener {
	private String cityName;
	private final IOpenPatricianPainter opPainter;
	private final IFontLoader fontLoader;

	public ViewStatus(Rectangle rect,IClient client) {
		super(rect);
		DisplayImageDIResolver resolver = DisplayImageDIResolver.getInstance();
		fontLoader =resolver.getFontLoader();
		opPainter = resolver.getOpenPatricianPainter();
		cityName = client.getPlayer().getHometown().getName();
		// TODO add to event queue
	}

	@Override
	public void gameRender(Graphics gScr) {
		Color oldColor = gScr.getColor();
//		gScr.setColor(Color.PINK);
//		gScr.fillRect(rect.x, rect.y, rect.width, rect.height);
		gScr.setColor(Color.WHITE);
//		final int x = 20+rect.x;
//		final int y = rect.y+rect.height/2;
//		gScr.drawString("ViewStatus", x, y);
		try {
			Font font = fontLoader.createDefaultDecorativeFont();
			font = font.deriveFont(18f);
			GlyphVector gv =opPainter.createGlyphVector((Graphics2D) gScr, cityName, font);
			Rectangle2D gvBounds = gv.getVisualBounds();
			int xPadding = (int) ((rect.width-gvBounds.getWidth())/2);
			((Graphics2D)gScr).drawGlyphVector(gv, rect.x+xPadding, (rect.y+rect.height)*3/4);
		} catch (FontFormatException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		gScr.setColor(oldColor);
		// TODO Auto-generated method stub

	}

	@Override
	public void gameUpdate(Event e, Object eventNotice) {
		// TODO Auto-generated method stub

	}

}
