package ch.sahits.game.graphic.display.gameplay.internal;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.TreeMap;

import org.apache.log4j.Logger;

import ch.sahits.game.graphic.image.DisplayImageDIResolver;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.IPolygonScaling;
import ch.sahits.game.graphic.image.model.ImageData;
import ch.sahits.game.graphic.image.model.NamedPolygon;
import ch.sahits.game.image.IImageUtilities;
import ch.sahits.game.image.ImageScaleState;

/**
 * This abstract class provides base functionallyty for loading and initializing a scene as well as doing stuff on that scene
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 17, 2012
 *
 */
abstract class AbstractSceneHandler implements ISceneHandler{
	private static final Logger logger = Logger.getLogger(AbstractSceneHandler.class); 

	/**
	 * Store the polygons for checking against clicking them
	 * Using a TreeMap so it may be possible do define polygons that cover the same
	 * are but in a different z-order.
	 */
	protected Map<Integer, NamedPolygon> polygons = new TreeMap<Integer, NamedPolygon>();
	/** This map holds the scaling factor for the different images */
	protected final Map<String,Double> scaleMap = new HashMap<String, Double>();
	/** Loader for data from the XML */
	protected final IDataImageLoader xmlLoader;
	protected final IImageUtilities imageUtils;
	private final Rectangle rect;
	/** Name of the image for this scene */
	protected final String SCENE_IMAGE_NAME;
	
	public AbstractSceneHandler(Rectangle parentBounds,IDataImageLoader xmlLoader, DisplayImageDIResolver resolver, String imageName) {
		super();
		this.xmlLoader = xmlLoader;
		imageUtils = resolver.getImageUtilities();
		rect = parentBounds;
		SCENE_IMAGE_NAME = imageName;
	}
	/**
	 * Find the polygon name that contains the coordinates. It is expected that the polygons
	 * are not overlapping. Is this not the case the first found polygon name is returned.
	 * @param x coordinate
	 * @param y coordinate
	 * @return name of the polygon
	 */
	protected String findPolygon(int x, int y) { // Use a better algo
		for (NamedPolygon poly : polygons.values()) {
			if (poly.contains(x, y)) {
				return poly.getName();
			}
		}
		return null;
	}
	/**
	 * Setting the positions of the polygons on the screen
	 */
	protected void initPolygons(DisplayImageDIResolver resolver,
			ImageData imgData, ImageScaleState state, Point offset) {
		IPolygonScaling scaler = resolver.getPolygonCalculator();
		ImageData recalculated = scaler.recalculatePolygons(imgData, state);
		recalculated = scaler.recalculatePolygonsOffsett(recalculated, offset);
		for (Entry<Integer, NamedPolygon> item : recalculated.getPolygons().entrySet()) {
			NamedPolygon poly = item.getValue();
			int zIndex = item.getKey();
			logger.debug("Add polygon: "+poly);
			this.polygons.put(zIndex, poly); // maybe we should use meanX instead
		}		
	}
	protected Rectangle getBounds() {
		return rect;
	}
	/**
	 * Retrieve the image that is cached with this handler
	 * @return
	 */
	@Override
	public BufferedImage getImage(){
		return xmlLoader.getImage(SCENE_IMAGE_NAME);
	}


}
