package ch.sahits.game.graphic.display.gameplay.internal;

import java.awt.image.BufferedImage;

import ch.sahits.game.event.Event;
import ch.sahits.game.graphic.display.gameplay.IUpdatableDialog;
import ch.sahits.game.graphic.display.model.CityPlayerProxy;
import ch.sahits.game.graphic.image.DisplayImageDIResolver;

/**
 * this interface defines the methods of a scene handler that are accessible from outside this package
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 17, 2012
 *
 */
public interface ISceneHandler {
	/**
	 * Initialize the images and polygons of the scene
	 * @param resolver to be used to load the images
	 * @return Buffered image that is initialized as the scene.
	 */
	public BufferedImage init(DisplayImageDIResolver resolver);
	/**
	 * Update the scene based on an event. This method allows the gameUpdate method of MainView to delegate the
	 * responsability, as the inner working of the scene is unknown to the MainView
	 * @param e
	 * @param eventNotice
	 * @param city
	 * @param dialogUpdater
	 */
	public void updateScene(Event e, Object eventNotice, CityPlayerProxy city, IUpdatableDialog dialogUpdater);
	/**
	 * Retrieve the image that is cached with this handler
	 * @return
	 */
	public BufferedImage getImage();
}
