package ch.sahits.game.graphic.display.gameplay.internal;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import org.apache.log4j.Logger;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.Event;
import ch.sahits.game.event.MouseClickEvent;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.dialog.ConsumtionProductionStockDialog;
import ch.sahits.game.graphic.display.dialog.TradingStockDialog;
import ch.sahits.game.graphic.display.gameplay.IUpdatableDialog;
import ch.sahits.game.graphic.display.gameplay.MainView;
import ch.sahits.game.graphic.display.model.CityPlayerProxy;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxy;
import ch.sahits.game.graphic.display.notice.NoticeView;
import ch.sahits.game.graphic.image.DisplayImageDIResolver;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.model.ImageData;
import ch.sahits.game.image.ImageScaleState;
/**
 * Scene handler that handles the market place related scenes
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 17, 2012
 *
 */
public class MarketPlaceScenehandler extends AbstractSceneHandler{
	private static final Logger logger = Logger.getLogger(MarketPlaceScenehandler.class);
	private final static String[] polyNames = {"MarketBooth","Floor"};

	public MarketPlaceScenehandler(Rectangle parentBounds,
			IDataImageLoader xmlLoader, DisplayImageDIResolver resolver) {
		super(parentBounds, xmlLoader, resolver,"marketPlaceScene");
	}

	@Override
	public BufferedImage init(DisplayImageDIResolver resolver) {
		BufferedImage tmpImg = xmlLoader.getImage(SCENE_IMAGE_NAME); // portScene
		ImageData imgData = xmlLoader.getImageData(SCENE_IMAGE_NAME);
		ImageScaleState state = new ImageScaleState(new Dimension(tmpImg.getWidth(), tmpImg.getHeight()), getBounds().getSize(), imgData.getCrop(), imgData.getMaxCrop());
logger.debug("State of the market place scene before: "+state);		
		BufferedImage img = imageUtils.cropAndScale(tmpImg, state);
		scaleMap.put(SCENE_IMAGE_NAME, state.getScaleFactor());
		Rectangle bounds = imageUtils.computeBounds(getBounds().getSize(),new Dimension(img.getWidth(),img.getHeight()));
		initPolygons(resolver, imgData, state, new Point(getBounds().x+bounds.x, getBounds().y+bounds.y)); 
		
logger.debug("State of the market place scene after : "+state);		
		xmlLoader.replaceSingleImage(SCENE_IMAGE_NAME, img);
		return img;
	}

	@Override
	public void updateScene(Event e, Object eventNotice, CityPlayerProxy city,
			IUpdatableDialog dialogUpdater) {
		if (e instanceof MouseClickEvent){
			Point p = (Point) eventNotice;
			String polyName = findPolygon(p.x, p.y);
			if (polyName==null){
				// no polygon defined at that location
				return;
			}
logger.debug("Clicked into polygon "+polyName);
			if (polyName.equals(polyNames[0])){ // market booth
				displayTradingStockdialog(city, dialogUpdater);
			} // end market booth
			else if (polyName.equals(polyNames[1])){ // Floor
				// Back to port
				ViewChangeCityPlayerProxy proxy = new ViewChangeCityPlayerProxy(city, EViewChangeEvent.MAIN_VIEW_PORT);
				new ViewChangeEvent(MainView.class).notify(proxy);
				
			}
		} else if (e instanceof ViewChangeEvent){
			if (((ViewChangeEvent)e).getAddresse()==dialogUpdater.getClass()){
				EViewChangeEvent change = (EViewChangeEvent) eventNotice;
				switch (change) {
				case CLOSE_DIALOG:
					dialogUpdater.updateDialog(null);
					break;

				default:
					break;
				}
			}
		}

	}
	/**
	 * Display the trading stock dialog
	 * @param city
	 * @param dialogUpdater
	 */
	public void displayTradingStockdialog(CityPlayerProxy city,
			IUpdatableDialog dialogUpdater) {
		BufferedImage dialogImg = dialogUpdater.getDialogFringe();
		Point topLeft = new Point(getBounds().x+(getBounds().width-dialogImg.getWidth())/2,getBounds().y+(getBounds().height-600)/2);
		// update the notice
		ViewChangeCityPlayerProxy proxy = new ViewChangeCityPlayerProxy(city, EViewChangeEvent.NOTICE_MARKET_BOOTH);
		new ViewChangeEvent(NoticeView.class).notify(proxy);
		// Open the dialog
		final double dialogScale = scaleMap.get(SCENE_IMAGE_NAME);
		dialogUpdater.updateDialog(new TradingStockDialog(topLeft, dialogScale, city));
	}
	/**
	 * Display the consumption and production dialog
	 * @param city
	 * @param dialogUpdater
	 */
	public void displayConsumtionProductionDialog(CityPlayerProxy city, IUpdatableDialog dialogUpdater){
		BufferedImage dialogImg = dialogUpdater.getDialogFringe();
		Point topLeft = new Point(getBounds().x+(getBounds().width-dialogImg.getWidth())/2,getBounds().y+(getBounds().height-600)/2);
		// we do not need updating here as that is handled by the notice view itself
		// Open the dialog
		final double dialogScale = scaleMap.get(SCENE_IMAGE_NAME);
		dialogUpdater.updateDialog(new ConsumtionProductionStockDialog(topLeft, dialogScale, city));
	}

}
