package ch.sahits.game.graphic.display.gameplay.internal;

import java.awt.Rectangle;
import java.util.HashMap;

import ch.sahits.game.graphic.image.DisplayImageDIResolver;
import ch.sahits.game.graphic.image.IDataImageLoader;

/**
 * Factory class for the different scene loaders. This factory class uses caching. Once a instance is created and put into the
 * cache, the cached instance will be returned.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 17, 2012
 *
 */
public class SceneHandlerFactory {
	/** Cache for the scene loaders */
	private static HashMap<EScene, ISceneHandler> cache = new HashMap<EScene, ISceneHandler>();
	
	public static ISceneHandler getSceneLoader(EScene scene, Rectangle parentsBounds, IDataImageLoader imgDataLoader, DisplayImageDIResolver resolver){
		ISceneHandler loader = cache.get(scene);
		if (loader!=null){ 
			return loader;
		}
		switch(scene){
		case PORT:
			loader = new PortSceneHandler(parentsBounds,imgDataLoader,resolver);
			cache.put(scene, loader);
			return loader;
		case MARKET:
			loader = new MarketPlaceScenehandler(parentsBounds, imgDataLoader, resolver);
			cache.put(scene, loader);
			return loader;
		default:
			throw new IllegalArgumentException("Implementation for "+scene+" is missing");
		}
	}
}
