package ch.sahits.game.graphic.display.model;

import java.util.List;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;

public interface ICityPlayerProxy {

	/**
	 * Retrieve the players active ship
	 * @return
	 */
	public IShip getActiveShip();

	/**
	 * Retrieve the list of all ships of the player currently in the port. The list is unmodifiable.
	 * @return unmodifiable list of the players ships
	 */
	public abstract List<IShip> getPlayersShips();
	/**
	 * Retrieve the city reference
	 * @return
	 */
	public ICity getCity();
	/**
	 * retrieve the player reference
	 * @return
	 */
	public IPlayer getPlayer();

}