package ch.sahits.game.graphic.display.model;

import java.util.List;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;

/**
 * Proxy object for city player for view changes.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 19, 2011
 *
 */
public class ViewChangeCityPlayerProxy implements ICityPlayerProxy {
	
	private final EViewChangeEvent viewchange;
	private final ICityPlayerProxy proxy;
	/**
	 * Constructor by making a copy of the passed proxy
	 * @param proxy
	 */
	public ViewChangeCityPlayerProxy(ICityPlayerProxy proxy,EViewChangeEvent event){
		this.proxy=proxy;
		this.viewchange=event;
	}
	
	public EViewChangeEvent getViewChangeEvent(){
		return viewchange;
	}

	@Override
	public IShip getActiveShip() {
		return proxy.getActiveShip();
	}

	@Override
	public List<IShip> getPlayersShips() {
		return proxy.getPlayersShips();
	}
	@Override
	public ICity getCity() {
		return proxy.getCity();
	}

	public IPlayer getPlayer() {
		return proxy.getPlayer();
	}
	
}
