package ch.sahits.game.graphic.display.notice;

import ch.sahits.game.graphic.display.model.ICityPlayerProxy;

/**
 * Retpresents the meta data responsible for the market boot statistics
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 18, 2012
 *
 */
public class MarketBoothDialogMetaData extends CityNoticeMetaData {
	/*
	 * The member variables of this class are not private since the class is
	 * package private and there is no interface for this class defining access.
	 * Reference to this class is only provided through the marker interface.
	 * Therefore any class utilizing these meta data must know of its data.
	 */
	/** State of the string linking to the stat displaing available wares and their prices */
	 EStringSelectionState stockPrices;
	 /** State of the string linking to the stat displaying consumtion and production */
	 EStringSelectionState consumtionProduction;
	public MarketBoothDialogMetaData(ICityPlayerProxy proxy,
			EStringSelectionState stockPrices,
			EStringSelectionState consumtionProduction) {
		super(proxy);
		this.stockPrices = stockPrices;
		this.consumtionProduction = consumtionProduction;
	}
	@Override
	public String toString() {
		return "MBmeta [stockPrices=" + stockPrices
				+ ", consumtionProduction=" + consumtionProduction + "]";
	}


}
