package ch.sahits.game.graphic.display.notice;

import ch.sahits.game.graphic.display.model.ICityPlayerProxy;

/**
 * Represent the meta data for the notice corresponding to the trade dialog.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 21, 2011
 *
 */
class TradeDialogMetaData extends CityNoticeMetaData {
	/*
	 * The member variables of this class are not private since the class is
	 * package private and there is no interface for this class defining access.
	 * Reference to this class is only provided through the marker interface.
	 * Therefore any class utilizing these meta data must know of its data.
	 */
	/** State of the string linking to the trade dialog city<->ship */
	EStringSelectionState city2ship;
	/** State of the string linking to the trade dialog office<->ship */
	EStringSelectionState office2ship;
	/** State of the String linking to the trade dialog city<->office */
	EStringSelectionState city2office;
	/** State of the String linking to the weapons trade dialog */
	EStringSelectionState weapons;
	public TradeDialogMetaData(EStringSelectionState city2ship,
			EStringSelectionState office2ship,
			EStringSelectionState city2office, EStringSelectionState weapons, ICityPlayerProxy proxy) {
		super(proxy);
		this.city2ship = city2ship;
		this.office2ship = office2ship;
		this.city2office = city2office;
		this.weapons = weapons;
	}
	/**
	 * Set all states to inactivate if they are not disabled to begin with
	 */
	public void inactivateAllNotDisabled(){
		if (city2office!=EStringSelectionState.DISABLE){
			city2office=EStringSelectionState.INACTIVE;					
		}
		if (city2ship!=EStringSelectionState.DISABLE){
			city2ship=EStringSelectionState.INACTIVE;					
		}
		if (office2ship!=EStringSelectionState.DISABLE){
			office2ship=EStringSelectionState.INACTIVE;					
		}
		if (weapons!=EStringSelectionState.DISABLE){
			weapons=EStringSelectionState.INACTIVE;					
		}
	}
	@Override
	public String toString() {
		return "TFmeta ["+ city2ship + ", "
				+ office2ship + ", " + city2office + ", "
				+ weapons + "]";
	}
	
	
}
