package ch.sahits.game.graphic.display.notice;

import ch.sahits.game.graphic.display.model.ICityPlayerProxy;

/**
 * Meta data for the trading office
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 20, 2012
 *
 */
class TradingOfficeDialogMataData extends CityNoticeMetaData {
	/*
	 * The member variables of this class are not private since the class is
	 * package private and there is no interface for this class defining access.
	 * Reference to this class is only provided through the marker interface.
	 * Therefore any class utilizing these meta data must know of its data.
	 */
	/** State of the string linking to the balance sheet */
	EStringSelectionState balance;
	/** State of the string linking to the personal data overview */
	EStringSelectionState personal;
	 /** State of the string linking to the statistic displaying consumption and production */
	EStringSelectionState consumtionProduction;
	/** State of the string linking to the weapons storage */
	EStringSelectionState weapons;
	/** State of the string linking to the warehouse overview */
	EStringSelectionState warehouses;
	/** State of the string linking to the storage manager */
	EStringSelectionState storageManager;
	public TradingOfficeDialogMataData(ICityPlayerProxy proxy,
			EStringSelectionState balance, EStringSelectionState personal,
			EStringSelectionState consumtionProduction,
			EStringSelectionState weapons, EStringSelectionState warehouses,
			EStringSelectionState storageManager) {
		super(proxy);
		this.balance = balance;
		this.personal = personal;
		this.consumtionProduction = consumtionProduction;
		this.weapons = weapons;
		this.warehouses = warehouses;
		this.storageManager = storageManager;
	}
	@Override
	public String toString() {
		return "TOmeta [balance=" + balance
				+ ", personal=" + personal + ", consumtionProduction="
				+ consumtionProduction + ", weapons=" + weapons
				+ ", warehouses=" + warehouses + ", storageManager="
				+ storageManager + "]";
	}
	/**
	 * Inactivate all links that are not disabled
	 */
	public void inactivateAll(){
		if (balance!=EStringSelectionState.DISABLE) balance=EStringSelectionState.INACTIVE;
		if (personal!=EStringSelectionState.DISABLE) personal=EStringSelectionState.INACTIVE;
		if (consumtionProduction!=EStringSelectionState.DISABLE) consumtionProduction=EStringSelectionState.INACTIVE;
		if (weapons!=EStringSelectionState.DISABLE) weapons=EStringSelectionState.INACTIVE;
		if (warehouses!=EStringSelectionState.DISABLE) warehouses=EStringSelectionState.INACTIVE;
		if (storageManager!=EStringSelectionState.DISABLE) storageManager=EStringSelectionState.INACTIVE;
	}
	
	
}
