package ch.sahits.game.graphic.display.util;

import java.awt.Point;

/**
 * This specialisation of the {@link ClickablePolygons} class provides
 * a test method for a given Y-Offset. The polygons are defined by forms
 * on an image. The image may however be moved by an offset in the y direction.
 * This offset must be considered when checking against the polygons.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 19, 2011
 *
 */
public class ClickableOffsetPolygons extends ClickablePolygons {
	/**
	 * Find the polygon that contains the point and if such a polygon
	 * exists execute its action
	 * @param p coordinates clicked on the screen
	 * @param yOffset offset the underling image is scrolled in y direction
	 */
	public void testAndExecute(Point p, int yOffset){
		testAndExecute(new Point(p.x,p.y-yOffset));
	}

}
