package ch.sahits.game.graphic.image;

import java.util.Locale;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DisplayImageDIResolver extends ImageDIResolver {
	private BeanFactory factory;
	private static DisplayImageDIResolver INSTANCE=null;
	/**
	 * Make the constructor portected to ensure it only can be called from super classes
	 * implementing the singleton pattern
	 */
	protected DisplayImageDIResolver(){
		super();
	}
	public static DisplayImageDIResolver getInstance(){
		if (INSTANCE==null){
			INSTANCE=new DisplayImageDIResolver();
		}
		return INSTANCE;
	}

	@Override
	public void init() {
		super.init();
		factory = new ClassPathXmlApplicationContext("springContext.xml");
	}
	/**
	 * Retrieve the image loader for the main sceen images
	 * @return
	 */
	public IImageLoader getMainScreenLoader(){
		return (IImageLoader) factory.getBean("mainScreenImageLoader");
	}
	/**
	 * Retrieve the image loader for the start sceen images
	 * @return
	 */
	public IImageLoader getStartScreenLoader(){
		return (IImageLoader) factory.getBean("mainScreenImageLoader");
	}
	/**
	 * Retrieve the XML image loader for the main screen
	 * @return
	 */
	public IDataImageLoader getXMLImageLoader(){
		return (IDataImageLoader) factory.getBean("mainScreenXMLImageLoader");
	}
	/**
	 * Retrieve a language aware image loader for the start screen images
	 * @param locale to be used
	 * @return
	 */
	public ILanguageAwareImageLoader getLanguageStartupScreanLoader(Locale locale){
		return (ILanguageAwareImageLoader) factory.getBean("languageImageLoader", new Object[]{"startScreen.txt",locale});
	}

}
