package ch.sahits.game.graphic.layout;

import java.awt.FontFormatException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

import ch.sahits.game.graphic.display.ISahitsComponent;
import ch.sahits.game.graphic.image.DisplayImageDIResolver;
import ch.sahits.game.graphic.image.IOpenPatricianSlabPainter;

public abstract class AbstractSahitsComponent implements ISahitsComponent {
	private Rectangle bounds = new Rectangle();
	private Insets insets = new Insets(0, 0, 0, 0);
	protected static final IOpenPatricianSlabPainter painter = DisplayImageDIResolver.getInstance().getOpenPatricianSlabPainter();
		
	/**
	 * Retrieve the bounds
	 * @return
	 */
	@Override
	public Rectangle getBounds(){
		return bounds;
	}

	@Override
	public void setBounds(int x, int y, int width, int height) {
		bounds = new Rectangle(x, y, width, height);
//System.out.println("Set Bounds: "+width+","+height);
	}
	/**
	 * Retrieve the insets
	 * @return
	 */
	protected Insets getInsets(){
		return insets;
	}

	@Override
	public void setInsets(int top, int right, int bottom, int left) {
		insets = new Insets(top, left, bottom, right);
	}

	/**
	 * Create the visual bounds for the string using the set font
	 * @param s String to be used
	 * @return Rectangle representing the visual bounds of s
	 */
	protected final Rectangle2D createVisualBounds(String s) {
		try {
			GlyphVector gv = painter.createGlyphVector(s, getFont().getSize());
			Rectangle2D view = gv.getVisualBounds();
			return view;
		} catch (FontFormatException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}


}
