package ch.sahits.game.graphic.layout;

import java.util.LinkedList;

/**
 * Group of components that are selectable
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jun 9, 2011
 *
 */
public class SelectableGroup {

	private LinkedList<AbstractSelectableComponent> selectables = new LinkedList<AbstractSelectableComponent>();
	/**
	 * Add a new selectable to the group
	 * @param selectable
	 */
	public void add(AbstractSelectableComponent selectable){
		selectables.add(selectable);
	}
	/**
	 * Remove a selectable. If the selectable is not contained in this group nothing happens
	 * @param selectable
	 */
	public void remove(AbstractSelectableComponent selectable){
		selectables.remove(selectable);
	}
	/**
	 * Unselect all other selectables than the the passed
	 * @param selected
	 */
	public void unselectOthers(AbstractSelectableComponent selected){
		for (AbstractSelectableComponent comp : selectables) {
			if (!comp.equals(selected)){
				comp.setSelected(false);
			}
		}
	}
}
