package ch.sahits.game.graphic.layout;

import java.awt.Dimension;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

import ch.sahits.game.graphic.image.IImageLoader;
import ch.sahits.game.graphic.image.ImageDIResolver;

public class Spinner extends AbstractMultiselectableComponent<String> {
	
	private final IImageLoader loader;
	
	private Rectangle upSpinner= new Rectangle();
	private Rectangle downSpinner= new Rectangle();
	private final FontMetrics metric;


	public Spinner(FontMetrics fm){
		metric = fm;
		ImageDIResolver resolver = ImageDIResolver.getInstance();
		loader = resolver.getIndividualImageLoader();
	}

	@Override
	public void paint(Graphics g) {
		Rectangle rect = getBounds();
		BufferedImage img = painter.createScaledPlank(rect.width, rect.height);
		g.drawImage(img, rect.x, rect.y, img.getWidth(), img.getHeight(), null);
		String s = getSelected();
		if (s!=null && s.length()>0){
			try {
				GlyphVector gv = painter.createGlyphVector(s, getFont().getSize());
				Insets insets = getInsets();
				int x = rect.x+insets.left;
				int y = rect.y+insets.top+rect.height;// 
				int descent = metric.getDescent();
				int textHeight = descent+metric.getAscent();
				int space = (rect.height-textHeight)/2;
				// TODO compute the center:
				((Graphics2D)g).drawGlyphVector(gv, x, y-descent-space); // (x,y) denotes the baseline of the leftmost character
			} catch (FontFormatException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		// Draw spinner buttons
		int xSpaceing = img.getWidth();
	    BufferedImage icon = loader.loadImage("SlabUp.png");
		int h = icon.getHeight();
		g.drawImage( icon, rect.x+xSpaceing,rect.y,null);
		upSpinner = new Rectangle(rect.x+xSpaceing, rect.y, icon.getWidth(), icon.getHeight());
	    icon = loader.loadImage("SlabDown.png");
		g.drawImage(icon, rect.x+xSpaceing,rect.y+h,null);
		downSpinner = new Rectangle(rect.x+xSpaceing,rect.y+h, icon.getWidth(), icon.getHeight());
		
	}

	@Override
	public Dimension getPreferredSize() {
		int maxSize = 0;
		for (String s : selectables) {
			if (maxSize<s.length()){
				maxSize = s.length();
			}
		}
		final int widthSpinner = 11;
		final int heightSpinner = 14+19;
		final String wString = "m";
		Dimension dim = new Dimension();
		Insets insets = getInsets();
		Rectangle2D rect = createVisualBounds(wString);
		if (rect!=null){
			dim.width=maxSize*(int) Math.rint(rect.getWidth())+insets.right+insets.left+widthSpinner;
		}
		dim.height=heightSpinner;
		return dim;
	}

	public void testClick(MouseEvent e) {
		if (upSpinner.contains(e.getPoint())){
			decSelection();
			gameUpdate();
		} else if (downSpinner.contains(e.getPoint())){
			incSelection();
			gameUpdate();
		}
		
	}
	@Override
	public void testClick(Point p) {
		if (upSpinner.contains(p)){
			decSelection();
			gameUpdate();
		} else if (downSpinner.contains(p)){
			incSelection();
			gameUpdate();
		}
		
	}
//	@Override
//	public void testMouseReleased(MouseEvent e) {
//		// not handled
//	}
//	@Override
//	public void testMouseDrag(MouseEvent e) {
//		// not handled
//	}

}
