package ch.sahits.game;

import ch.sahits.game.graphic.display.OpenPaticianApplicationWindow;
import ch.sahits.game.openpatrician.server.ServerLauncher;
import ch.sahits.game.openpatrician.spring.StandaloneConfiguration;
import ch.sahits.game.openpatrician.util.PropertyLoader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

import java.util.Properties;

/**
 * Main class for starting the OpenPatrician game.
 * <br/>
 * The following system properties are evaluated:
 * <ul>
 *     <li>javafx.polygon.shading: The polygons that are used to define an area are colored</li>
 * </ul>
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 16, 2011
 *
 */
public class OpenPatrician {
	
	private static Logger logger = Logger.getLogger(OpenPatrician.class);
	
//	private final static String START_CLIENT = "-c";
//	private final static String START_SERVER = "-s";
//	private final static String HELP = "?";
	

	private volatile static boolean startedServer = false;
	
	private final static Object lock = new Object();

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Properties properties = PropertyLoader.loadProperties("log4j.properties");
		PropertyConfigurator.configure(properties);
		logEnvironment();
		CommandLineArguments cmdHelper = new CommandLineArguments();
		Options opts = cmdHelper.createCommandLineOptions();
		CommandLine cmdLine = cmdHelper.parseCommandLine(opts, args);
		if (cmdLine.hasOption(CommandLineArguments.HELP_OPTION)){
			cmdHelper.printHelp(opts);
			System.exit(0);
		}
		if (cmdLine.hasOption(CommandLineArguments.VERSION_OPTION)) {
			System.out.println("OpenPatrician version: "+OpenPatrician.class.getPackage().getImplementationVersion());
			System.exit(0);
		}
		cmdHelper.persistAsPropertyFile(cmdLine);
		if (cmdHelper.isServer(cmdLine)){
			logger.error("Multiplayer game is not yet implemented, sorry.");
			System.exit(0);
		} else {
            if (cmdHelper.isStandalone(cmdLine)) {
                // also need to create the server
                 ServerLauncher.initializeApplicationContext(StandaloneConfiguration.class);
            }
            OpenPaticianApplicationWindow.startClientUI(new String[0]);
		}

	}

	private static void logEnvironment() {
		Properties sysprops = System.getProperties();
		StringBuilder sb = new StringBuilder();
		sb.append("Java VM version").append(": ").append(sysprops.get("java.vm.version"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Java runtime version").append(": ").append(sysprops.get("java.runtime.version"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Java VM vendor").append(": ").append(sysprops.get("java.vm.vendor"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Java VM name").append(": ").append(sysprops.get("java.vm.name"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Java version").append(": ").append(sysprops.get("java.version"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Java specification version").append(": ").append(sysprops.get("java.specification.version"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Graphics environment").append(": ").append(sysprops.get("java.awt.graphicsenv"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("User country").append(": ").append(sysprops.get("user.country"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("User language").append(": ").append(sysprops.get("user.language"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("OS architecture").append(": ").append(sysprops.get("os.arch"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("OS name").append(": ").append(sysprops.get("os.name"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("OS version").append(": ").append(sysprops.get("os.version"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Start command").append(": ").append(sysprops.get("sun.java.command")); // ?? is this generally availalbe
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}

	}

//	/**
//	 * Create the server instance for a standalone game. If the server is already started no
//	 * second server will be started.
//	 * @param userGui Thread/Runnable that handels the users GUI rendering
//	 */
//	public static void createStandaloneServer(OpenPatricianFrame userGui){
//		synchronized (lock) {
//			if (startedServer) return; // only start the server once
//		}
//		// PRE: The server is not yet started
//		// TODO: create server with AI players and one human player
//	}
	
	// TODO add method connectToServer

}
