package ch.sahits.game.event.handler.impl;

import ch.sahits.game.graphic.display.dialog.ClosableDialog;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.base.Optional;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.property.ObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import java.util.Random;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Prototype
public class HirePirateEventHandler implements EventHandler<MouseEvent> {
    private final ObjectProperty<IShip> currentShip;
    private final ICityPlayerProxyJFX city;
    private final IPirate pirate;
    private final ClosableDialog delegateDialog;

    @Autowired
    private SeaPiratesState seaPiratesState;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;


    public HirePirateEventHandler(ObjectProperty<IShip> currentShip, ICityPlayerProxyJFX city, IPirate pirate, ClosableDialog delegateDialog) {
        this.currentShip = currentShip;
        this.city = city;
        this.pirate = pirate;
        this.delegateDialog = delegateDialog;
    }

    // todo: andi 22/12/13: differentiate between loacal and global
    @Override
    public void handle(MouseEvent mouseEvent) {
        final ISeaPirate seaPirate = seaPiratesState.createNewPirate(pirate.getName(), currentShip.get(), city.getCity().getCoordinates());
        seaPiratesState.add(seaPirate, Optional.of(city.getPlayer()));
        int nbDays = rnd.nextInt(200)+30;
        DateTime deadline = date.getCurrentDate().plus(nbDays);
        TimedTask task = new TimedTask() {
            @Override
            public void run() {
                seaPiratesState.free(city.getPlayer(), seaPirate);
            }
        };
        task.setExecutionTime(deadline);
        timedTaskListener.add(task);
        city.getPlayer().removeShip(currentShip.get());
        pirate.leave();

        int caughtProb = rnd.nextInt(3);
        if (caughtProb == 1) {
            deadline = date.getCurrentDate().plus(5);
            final int fine = (int)(Math.abs(city.getPlayer().getCash()/200*rnd.nextDouble()));
            task = new TimedTask() {
                @Override
                public void run() {
                    DisplayMessage msg = new DisplayMessage(messageSource.getMessage("ch.sahits.game.event.handler.impl.HirePirateEventHandler.fineMessage1", new Object[]{fine}, locale.getCurrentLocal()),
                            messageSource.getMessage("ch.sahits.game.event.handler.impl.HirePirateEventHandler.fineMessage2", new Object[]{}, locale.getCurrentLocal()));
                    clientEventBus.post(msg);
                    city.getPlayer().updateCash(-fine);
                }
            };
            task.setExecutionTime(deadline);
            timedTaskListener.add(task);
        }
        delegateDialog.executeOnCloseButtonClicked();

    }}
