package ch.sahits.game.event.handler.impl;


import ch.sahits.game.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;

import javax.annotation.PostConstruct;

/**
 * The passenger leaves the ship when it arrives in the city and the player gets
 * a certain amount of money.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Feb 19, 2013
 *
 */
@Prototype
class PassengerLeavesShipOnArival extends ShipEntersPortEventListener {
	private final int premium;
	private final IPlayer shipsOwner;
	public PassengerLeavesShipOnArival(IShip ship, ICity city, IPlayer shipsOwner, int premium) {
		super(ship, city);
		this.premium = premium;
		this.shipsOwner = shipsOwner;
	}
    @PostConstruct
    private void initializeEventBus() {
        clientServerEventBus.register(this);
    }

	@Override
	public boolean execute() {
		getShip().leavePassanger();
		shipsOwner.updateCash(premium);
		clientServerEventBus.unregister(this);
		return true;
	}

}
