package ch.sahits.game.event.handler.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * Event handler for a ship arrival for loading of wares.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 16, 2014
 */
@Prototype
class ShipArrivalForLoading extends WaitTimeForShipArrival {
    private final int requiredAmount;
    private final int premium;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;

    public ShipArrivalForLoading(ICity city, IPlayer player, DateTime deadline, int requiredAmount, int premium) {
        super(city, player, deadline);
        this.requiredAmount = requiredAmount;
        this .premium = premium;
    }
    @PostConstruct
    private void initializeEventBus() {
        clientServerEventBus.register(this);
    }

    @Override
    public boolean execute() {
        if (hasShipEnoughCapacity(getShip(), requiredAmount)) {
            getShip().setOccupiedSpace(requiredAmount + getShip().getOccupiedSpace());
            DateTime waitTenDays = getDate().getCurrentDate().plusDays(10);

            eventHandlerFactory.getDeliverPackagesHandler(getCity(), getShip(), waitTenDays, premium, requiredAmount);
            return true;
        }
        return false;
    }


    /**
     * Check if the ship has enough capacity to load wares
     * @param ship
     * @param requiredAmount in barrels
     * @return
     */
    private static boolean hasShipEnoughCapacity(IShip ship, int requiredAmount) {
        return ship.getCapacity()>requiredAmount;
    }

}
