package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.ShipAttackEvent;
import ch.sahits.game.event.handler.TimedEventListener;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 22, 2014
 */
@Prototype
public class SinkConcurrentsShipOrder  extends TimedEventListener {
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    private final IPlayer opponent;
    private final IPlayer player;
    private final int premium;
    private final TimedTask reconciliation;
    private final int offeredTime;
    @Autowired
    private TimedUpdatableTaskList list;

    public SinkConcurrentsShipOrder(IPlayer opponent,
                                    IPlayer player, int offerdTime, int premium, TimedTask reconciliation) {
        this.offeredTime = offerdTime;
        this.opponent = opponent;
        this.player = player;
        this.premium = premium;
        this.reconciliation = reconciliation;
    }
    @PostConstruct
    private void initialize() {
        setDeadline(date.getCurrentDate().plusDays(offeredTime));
        clientServerEventBus.register(this);
    }

    /**
     * Handle the ships attak
     * @param event
     */
    @Subscribe
    public void handleShipAttack(ShipAttackEvent event) {
        if (deadline.isAfter(date.getCurrentDate())) {
            IPlayer attackedOwner = event.getAttackedShip().getOwner();
            IPlayer attackingOwner = event.getAttackingShip().getOwner();
            if (attackedOwner != null && attackedOwner.equals(opponent)
                    && attackingOwner != null && attackingOwner.equals(player)) {
                execute();
                clientServerEventBus.unregister(this);
            }
        } else {
            destroy();
            clientServerEventBus.unregister(this);
        }
    }
    @Override
    public boolean execute() {
        clientEventBus.post(new DisplayMessage(messageSource.getMessage("ch.sahits.game.event.handler.impl.SinkConcurrentsShipOrder.thankyou", new Object[]{}, locale.getCurrentLocal())));
        player.updateCash(premium);
        if (reconciliation != null) {
            list.remove(reconciliation);
        }
        return true;
    }}
