package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.*;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * Event handler runnable for changing the tavern dialog.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 17, 2014
 */
@Prototype
class TavernDialogChangeAction implements Runnable {
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    private final IPerson showingPerson;
    private final TavernState tavernState;
    private final IPlayer player;

    public TavernDialogChangeAction(IPerson showingPerson,
                                    TavernState tavernState,
                                    IPlayer currentPlayer) {
        this.showingPerson = showingPerson;
        this.tavernState = tavernState;
        this.player = currentPlayer;
    }

    @Override
    public void run() {
        boolean doUpdate=false;
        ENoticeItem selected = null;
        boolean canTalkToOnlyOnePerson = true;
        if (showingPerson instanceof IBuyer) {
            selected = ENoticeItem.TAVERN_BUYER;
            doUpdate = true;
        }
        if (showingPerson instanceof ISailors) {
            selected = ENoticeItem.TAVERN_SAILORS;
            doUpdate = true;
            canTalkToOnlyOnePerson = false;
        }
        if (showingPerson instanceof IWeaponsDealer) {
            selected = ENoticeItem.TAVERN_WEAPONS_DEALER;
            doUpdate = true;
            canTalkToOnlyOnePerson = false;
        }
        if (showingPerson instanceof IInformant) {
            selected = ENoticeItem.TAVERN_INFORMANT_1;
            doUpdate = true;
        }
        if (showingPerson instanceof ICaptain) {
            selected = ENoticeItem.TAVERN_CAPTAIN;
            doUpdate = true;
        }
        if (showingPerson instanceof IPirate) {
            selected = ENoticeItem.TAVERN_PIRATE;
            doUpdate = true;
        }
        if (showingPerson instanceof ITraveler) {
            selected = ENoticeItem.TAVERN_TRAVELER;
            doUpdate = true;
        }
        if (showingPerson instanceof ITrader) {
            selected = ENoticeItem.TAVERN_TRADER;
            doUpdate = true;
        }

        if (doUpdate) {
            if (canTalkToOnlyOnePerson) {
                tavernState.talkingToProperty().get().put(showingPerson, player);
            }
            clientEventBus.post(new ViewChangeEvent(MainGameView.class, selected));
        }
    }}
