package ch.sahits.game.graphic.display;

import ch.sahits.game.javafx.OpenPatricianScene;
/**
 * Interface allowing which allows the current scene to be replaced with another one.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 3, 2013
 *
 */
public interface SceneChangeable {

	/**
	 * Change the scene of the application
	 * @param scene
	 */
	void changeScene(OpenPatricianScene scene);
	/**
	 * Retrieve the width of the current scene. This is required
	 * to update the width dimension of the new scene. This is due to
	 * this bug: https://javafx-jira.kenai.com/browse/RT-30392
	 * @return scene width
	 */
	double getSceneWidth();
	/**
	 * Retrieve the height of the current scene. This is required
	 * to update the height dimension of the new scene. This is due to
	 * this bug: https://javafx-jira.kenai.com/browse/RT-30392
	 * @return scene height
	 */
	double getSceneHeight();

}