package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.data.CourierPatrolStateInternal;
import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.ICourier;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Random;

/**
 * Dialog for accepting the packages of a courier.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 23, 2013
 */
@Prototype
public class TavernCourierDialog extends TavernBaseSideRoomPersonDialog {
    private static final int AMOUNT = 3;
    @Autowired
    private Random rnd;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientTaskFactory taskFactory;


    public TavernCourierDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, city.getCity().getCityState().getTavernState().getCourier());
    }
    @PostConstruct
    private void initializeDialog(){
        setTitle( messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCourierDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();

        String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCourierDialog.dialog", new Object[0], locale.getCurrentLocal());

        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("city", city.getCity().getName());
        parameters.put("amount", AMOUNT);
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().add(dt);

    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                if (!tavernDialogUtil.noShipWithEnoughCapacityAvailable(city, AMOUNT)) {
                    for (IShip ship : city.getPlayersShips()) {
                        if (ship.getCapacity() >= AMOUNT*10) {
                            final ICourier courier = (ICourier) currentPerson.get();
                            ship.addPassenger(courier);
                            CourierPatrolStateInternal patrolState = new CourierPatrolStateInternal(courier.getPremium(), courier.getDestinations());
                            IPlayer player = city.getPlayer();
                            int minutes = rnd.nextInt(600);
                            DateTime postMessage = date.getCurrentDate().plusMinutes(minutes);
                            String cityName = patrolState.nextDestination().get().getName();
                            String message = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPatrolDialog.accpetMessage", new Object[]{ship.getName(), cityName}, locale.getCurrentLocal());
                            taskFactory.getPostponedDisplayMessage(postMessage, message);
                            DateTime firstDeadline = date.getCurrentDate().plusDays(6);
                            eventHandlerFactory.getNextCourierPatrolStationHanlder(ship, patrolState.nextDestination().get(), patrolState, player, firstDeadline);
                            courier.leave();
                            executeOnCloseButtonClicked();
                            break;
                        }
                    }
                }
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            {
               super.bind(city.getPlayersShips());
                // todo: andi 23/12/13: should not consider ships that are automated in some way (these are the ships which's capacity may change)
            }
            @Override
            protected boolean computeValue() {
                return tavernDialogUtil.noShipWithEnoughCapacityAvailable(city, AMOUNT);
            }
        };
    }

}
