package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.people.IEscorte;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.HashMap;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 27, 2013
 */
@Prototype
public class TavernEscortDialog extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private EventHandlerFactory eventHandlerFactory;


    public TavernEscortDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, city.getCity().getCityState().getTavernState().getEscorte());
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernEscortDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        IEscorte escort = (IEscorte) currentPerson.get();

        String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernEscortDialog.dialog", new Object[0], locale.getCurrentLocal());

        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("destination", escort.getDestination().getName());
        parameters.put("price", escort.getPremium());
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().addAll(dt);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                if (city.getActiveShip()!=null) {
                    IEscorte escort = (IEscorte) currentPerson.get();
                    city.getActiveShip().addPassenger(escort);
                    IShip ship = city.getActiveShip();
                    eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, escort.getDestination(), city.getPlayer(), escort.getPremium());
                    clientEventBus.post(new DisplayMessage(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernEscortDialog.acceptMessage", new Object[]{ship.getName()}, locale.getCurrentLocal())));
                    escort.leave();
                    executeOnCloseButtonClicked();
                }
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            {
                super.bind(city.getPlayersShips());
            }
            @Override
            protected boolean computeValue() {
                return city.getPlayersShips().isEmpty();
            }
        };
    }
}
