package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.event.handler.impl.HirePirateEventHandler;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.util.DialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Random;

/**
 * Dialog for offering a ship to a pirate.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 22, 2013
 */
@Prototype
public class TavernPirateDialog extends CloseButtonDialog implements ClosableDialog {
    private final ICityPlayerProxyJFX city;
    private final Font font;
    private final ObjectProperty<IShip> currentShip;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private SeaPiratesState seaPiratesState;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private Locale locale;

    @Autowired
    private MessageSource messageSource;

    private final IPirate pirate;


    public TavernPirateDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
        this.currentShip = new SimpleObjectProperty<>(this, "currentShip", city.getActiveShip());
        pirate = city.getCity().getCityState().getTavernState().getPirate();
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateDialog.title", new Object[]{}, locale.getCurrentLocal()));

        int share = (int)Math.rint(pirate.getProfitShare()*100);
        String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateDialog.dialog", new Object[]{pirate.getFollowers(), share}, locale.getCurrentLocal());


        HashMap<String, Object> parameters = new HashMap<>();
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().add(dt);

        if (currentShip.get() == null) {
            Text noShip = new Text(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.noShip", new Object[]{}, locale.getCurrentLocal()));
            noShip.setFont(font);
            noShip.setLayoutX(2*FRAME_BORDER);
            noShip.setLayoutY(300);
            getContent().add(noShip);
        } else {
            Text selectedShip = new Text(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateDialog.shipSelection", new Object[]{}, locale.getCurrentLocal()));
            selectedShip.setLayoutX(2*FRAME_BORDER);
            selectedShip.setLayoutY(300);
            selectedShip.setFont(font);
            getContent().add(selectedShip);
            GridPane shipSelectionPane = dialogUtil.createShipSelection3Lines(city, currentShip, font);
            shipSelectionPane.setLayoutX(2 * FRAME_BORDER);
            shipSelectionPane.setLayoutY(350);
            getContent().add(shipSelectionPane);
            int xFirstButton = (100);
            int xSecondButton = (WIDTH - 100 - 124);

            OpenPatricianLargeWaxButton wholeHanse = new OpenPatricianLargeWaxButton(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateDialog.wholeHanse", new Object[]{}, locale.getCurrentLocal()), font);
            wholeHanse.setLayoutX(xFirstButton);
            wholeHanse.setLayoutY(CLOSE_BTN_Y_POS - 24);
            final HirePirateEventHandler hirePirateEventHandler = eventHandlerFactory.getHirePirateEventHandler(currentShip, city, pirate, this);
            wholeHanse.setOnAction(hirePirateEventHandler);
            OpenPatricianLargeWaxButton local = new OpenPatricianLargeWaxButton(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateDialog.local", new Object[]{city.getCity().getName()}, locale.getCurrentLocal()), font);
            local.setLayoutX(xSecondButton);
            local.setLayoutY(CLOSE_BTN_Y_POS - 24);
            local.setOnAction(eventHandlerFactory.getHirePirateEventHandler(currentShip,city, pirate, this));

            getContent().addAll(wholeHanse, local) ;

        }
    }

    /**
     * Update the notice board and close the dialog.
     */
    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TAVERN);
        clientEventBus.post(new NoticeBoardUpdate(proxy));
        super.executeOnCloseButtonClicked();
    }

}
