package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.util.TavernDialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.ITraveler;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.HashMap;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 26, 2013
 */
@Prototype
public class TavernTravelerDialog extends CloseButtonDialog {
    @Autowired
    private TavernDialogUtil tavernUtil;
    @Autowired
    private Date date;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private Locale locale;

    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ModelTranslations modelTranslator;

    private final ICityPlayerProxyJFX city;
    private final Font font;
    private final TavernState tavernState;
    private final ITraveler traveler;

    public TavernTravelerDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.font = font;
        this.city = city;
        tavernState = city.getCity().getCityState().getTavernState();
        traveler = tavernState.getTraveler();
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTravelerDialog.title", new Object[]{}, locale.getCurrentLocal()));
        IPlayer player = city.getPlayer();
        final DateTime arrivalDate = traveler.getArrivalDate();
        String d = date.todisplayString(arrivalDate.getDayOfMonth(), arrivalDate.getMonthOfYear(), arrivalDate.getYear());
        String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTravelerDialog.dialog",
                new Object[]{city.getPlayer().getLastName(), modelTranslator.getLocalDisplayName(player.getCareerLevel()), player.getName(), traveler.getDestination().getName(), d}, locale.getCurrentLocal());


        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("amount",traveler.getPremium());
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        final OpenPatricianLargeWaxButton acceptButton = new OpenPatricianLargeWaxButton(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[]{}, locale.getCurrentLocal()), font);
        int BUTTON_X = (WIDTH - 124) / 2;
        acceptButton.setLayoutX(BUTTON_X);
        int LOWER_BUTTON_Y = CLOSE_BTN_Y_POS - 24;
        acceptButton.setLayoutY(LOWER_BUTTON_Y);
        acceptButton.setOnAction(new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                IShip ship = city.getActiveShip();
                if (ship != null) {
                    ship.addPassenger(traveler);
                    eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, traveler.getDestination(), city.getPlayer(), traveler.getPremium());
                    clientEventBus.post(new DisplayMessage(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.acceptMessage", new Object[]{ship.getName()}, locale.getCurrentLocal())));

                    traveler.leave();
                    executeOnCloseButtonClicked();
                }
            }
        });
        BooleanBinding disable = disableAcceptBinding();
        acceptButton.setDisable(disable.get());
        disable.addListener(new ChangeListener<Boolean>() {
            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue,
                                Boolean oldValue, Boolean newValue) {
                acceptButton.setDisable(newValue);
            }
        });

        getContent().addAll(dt, acceptButton);
    }

    private BooleanBinding disableAcceptBinding() {
        return new BooleanBinding() {
            {
                super.bind(city.getPlayersShips());
            }
            @Override
            protected boolean computeValue() {
                return city.getActiveShip() == null;
            }
        };
    }
    /**
     * Update the notice board and close the dialog.
     */
    @Override
    protected void executeOnCloseButtonClicked() {
        tavernUtil.stopTalkingToPerson(tavernState, city.getPlayer());
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TAVERN);
        clientEventBus.post(new NoticeBoardUpdate(proxy));
        super.executeOnCloseButtonClicked();
    }
}
