package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.openpatrician.model.product.IWare;
import org.apache.log4j.Logger;

import java.util.HashMap;

/**
 * This proxy handles the execution of the buy action based on the current
 * type of the dialog.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 18, 2011
 *
 */
public class BuyJFXProxyAction implements Runnable {
	private static final Logger logger = Logger.getLogger(BuyJFXProxyAction.class);
	private final ITransferableJFX dialog;
	private final HashMap<EDialogType, Runnable> actionMap;
	

	public BuyJFXProxyAction(IWare ware, ITransferableJFX dialog) {
		super();
		this.dialog = dialog;
		actionMap = new HashMap<EDialogType, Runnable>();
		actionMap.put(EDialogType.CITY_TO_SHIP, new City2ShipJFXAction(ware, dialog));
		actionMap.put(EDialogType.CITY_TO_STORAGE, new City2StorageJFXAction(ware,dialog));
		actionMap.put(EDialogType.STORAGE_TO_SHIP, new Ship2StorageJFXAction(ware,dialog));
	}

	/**
	 * Delegate to the run method of the action associated with the dialog type
	 */
	@Override
	public void run() {
		Runnable action = actionMap.get(dialog.getDialogType());
		if (action==null){
			logger.error("No action defined for dialog transfer type: "+dialog.getDialogType());
		} else {
			action.run();
		}
	}

}
