package ch.sahits.game.graphic.display.gameplay.internal;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * Event handler for the city hall scene.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jan 03, 2015
 */
@Component
public class CityHallScenePolygonInitializer extends ScenePolygonInitialzer {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    public CityHallScenePolygonInitializer() {
        super("cityhall");
    }

    @Override
    protected EventHandler<MouseEvent> createEventHandler(String name) {
        switch (name) {
            case "Floor" : {
                return new EventHandler<MouseEvent>() {

                    @Override
                    public void handle(MouseEvent arg0) {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_MARKET);
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                    }
                };
            }
            // todo: andi 1/3/15: implement the cases for the other clickable areas commented out.
            default:
                throw new IllegalStateException("Unhandled polygon action: "+name);
        }

    }
}
