package ch.sahits.game.graphic.display.gameplay.internal;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Factory for retrieving the proper scene initializer for the current scene, to setup the polygons.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 13, 2013
 */
@Component
public class PolygonInitializerFactory {
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty<>(this, "currentScene", EScene.PORT);
    @Autowired
    private PortScenePolygonInitializer portSceneInitializer;
    @Autowired
    private MarketScenePolygonInitializer marketSceneInitializer;
    @Autowired
    private ShipyardScenePolygonInitializer shipyardSceneInitializer;
    @Autowired
    private TavernScenePolygonInitializer tavernSceneInitializer;
    @Autowired
    private CityHallScenePolygonInitializer cityHallSceneInitializer;
    @Autowired
    private LoanerScenePolygonInitializer loanerSceneInitializer;


    public ObjectProperty<EScene> currentSceneProperty() {
        return currentScene;
    }

    public ScenePolygonInitialzer getScenePolygonInitializer() {
        switch (currentScene.get()) {
            case PORT:
                return portSceneInitializer;
            case MARKET:
                return marketSceneInitializer;
            case SHIPYARD:
                return shipyardSceneInitializer;
            case TAVERN:
                return tavernSceneInitializer;
            case CITY_HALL:
                return cityHallSceneInitializer;
            case LOANER:
                return loanerSceneInitializer;
            default:
                throw new IllegalStateException("Unsupported scene: "+currentScene.get());
        }
    }

}
