package ch.sahits.game.graphic.event.task;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;

/**
 * Reconciliation between the two opponents.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 22, 2014
 */
@Prototype
class ConcurrentReconciliation extends TimedTask {
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList timedUpdatableTaskList;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;

    @Autowired
    private MessageSource messageSource;

    @PostConstruct
    private void initialize() {
        setExecutionTime(date.getCurrentDate().plusDays(20));
        timedUpdatableTaskList.add(this);
    }

    @Override
    public void run() {
        clientEventBus.post(new DisplayMessage(messageSource.getMessage("ch.sahits.game.graphic.event.task.ConcurrentReconciliation.message", new Object[]{}, locale.getCurrentLocal())));

    }
}
