package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.graphic.image.EScaleDirection;
import ch.sahits.game.graphic.image.ImageScaleState;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.shape.Polygon;

import java.util.List;
/**
 * Place the image view in the center
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 10, 2013
 *
 */
public class MainGameImageView extends Group {
    private boolean withPolygonShading = false;

    public MainGameImageView(double width, double height, ImageView imgView, ImageScaleState state) {
		setManaged(false);
        if (System.getProperty("javafx.polygon.shading") != null) {
            withPolygonShading = true;
        }
		setImageView(width, height, imgView, state);
	}
	/**
	 * Set the image view at the right position.
	 * @param width of the parent control
	 * @param height of the parent control
	 * @param imgView ImageView to be added.
	 */
	void setImageView(double width, double height, ImageView imgView, ImageScaleState state) {
		getChildren().clear();
		double x = Math.max((width - imgView.getBoundsInLocal().getWidth())/2,0);
		double y = Math.max((height - imgView.getBoundsInLocal().getHeight())/2,0);
		if (x > 0) {
			state.border();
			state.setBorderDirection(EScaleDirection.HORIZONTAL);
			state.setBordered((int) x);
		} else if (y > 0) {
			state.border();
			state.setBorderDirection(EScaleDirection.VERTICAL);
			state.setBordered((int) y);
		}
		imgView.setLayoutX(x);
		imgView.setLayoutY(y);
		getChildren().add(imgView);
	}
	/**
	 * Initialize the polygons
	 * @param polygons
	 */
	public void resetPolygons(List<Polygon> polygons) {
		ImageView imageView = getImageView();
        for (int i = 0; i < polygons.size(); i++) {
			Polygon polygon = polygons.get(i);
            if (imageView != null) {
                polygon.setLayoutX(imageView.getLayoutX());
                polygon.setLayoutY(imageView.getLayoutY());
            }
            if (withPolygonShading) {
                polygon.setFill(colors[i%colors.length]);
                polygon.setOpacity(0.5);
            } else {
                polygon.setFill(Color.TRANSPARENT);
            }

			getChildren().add(polygon);
		}
	}
    private ImageView getImageView() {
        for (Node node : getChildren()) {
            if (node instanceof ImageView) {
                return (ImageView) node;
            }
        }
        return null;
    }
	
	private Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.PINK}; 
}
