package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.util.DialogFactory;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.gameplay.internal.PolygonInitializerFactory;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.IImageUtilities;
import ch.sahits.game.graphic.image.ImageScaleState;
import ch.sahits.game.graphic.image.model.ImageData;
import ch.sahits.game.openpatrician.dialog.Dialog;
import ch.sahits.game.openpatrician.annotation.DialogCloseing;
import ch.sahits.game.openpatrician.annotation.DialogOpening;
import ch.sahits.game.openpatrician.spring.DialogScope;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import java.util.List;

public class MainGameView extends Group implements  IDialogContoller {
	private static final Logger logger = Logger.getLogger(MainGameView.class);
    public static final int MINMIMAL_DISPLAY_HEIGHT = 766;
    /**
	 * Use low level byte to indicate what is displayed instead of an enum.
	 */
	private double controlWidth;
	private double controlHeight;

	@Autowired
	private IImageUtilities imageUtils;
	@Autowired
	private IDataImageLoader xmlLoader;
	@Autowired
	private IFontLoader fontLoader;
	@Autowired
	private DialogFactory dialogFactory;
	private Rectangle placeHolder;
	private MainGameImageView imgView;
	private Dialog dialog;
    @Autowired
    private DialogScope dialogScope;

	private ObjectProperty<EScene> currentScene = new SimpleObjectProperty<>(this, "currentScene", EScene.PORT);
    @Autowired
    private SceneEventHandlerFactory sceneEventHandlerFactory;
    @Autowired
    private PolygonInitializerFactory polygonInitFactory;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    private StackPane stack;

    public MainGameView(double width, double heigth) {
		super();
		setManaged(false);
		controlWidth = width;
		controlHeight = heigth;
	}

	@PostConstruct
	private void createComponents() {

        setUpImageView();

        sceneEventHandlerFactory.currentSceneProperty().bindBidirectional(currentScene);
        sceneEventHandlerFactory.setUpDialogController(this);

        polygonInitFactory.currentSceneProperty().bindBidirectional(currentScene);

        stack = new StackPane();
		stack.getChildren().add(imgView);
		placeHolder = new Rectangle(controlWidth, controlHeight);
		placeHolder.setFill(Color.BLACK);
		getChildren().addAll(placeHolder, stack);
        clientEventBus.register(this);
	}
	/**
	 * Retrieve the name for the image to be displayed in the scene
	 * @return
	 */
	private String getImageNameFromScene() {
		switch (currentScene.get()) {
		case MARKET:
			return "marketPlaceScene";
		case PORT:
			return "portScene";
		case SHIPYARD:
			return "shipYard";
		case TAVERN:
			return "tavernIterior";
		case CITY_HALL:
			return "cityhall";
		case LOANER:
			return "loaner";
		default:
			throw new RuntimeException(currentScene.get() + " is not implemented");
		}
	}

	private void setUpImageView() {
		String imageName = getImageNameFromScene();
		Image tmpImg = xmlLoader.getImage(imageName);
		ImageData imgData = xmlLoader.getImageData(imageName);
		Dimension2D targetDim = new Dimension2D(controlWidth, controlHeight);
		ImageScaleState state = new ImageScaleState(new Dimension2D(tmpImg.getWidth(), tmpImg.getHeight()), targetDim, imgData.getCrop(), imgData.getMaxCrop());
		logger.debug("State of the port scene before: "+state);

        // // todo: andi 13/12/13: it would be simpler to bound the values instead of reinitializing them
		imgView = new MainGameImageView(controlWidth, controlHeight, imageUtils.cropAndScale(imageName, state), state);
		List<Polygon> polygons = polygonInitFactory.getScenePolygonInitializer().initialzePolygons(state);
		imgView.resetPolygons(polygons);
		logger.debug("State of the port scene after : "+state);
	}

	public void widthChange(double oldWidth, double newWidth) {
		String imageName = getImageNameFromScene();
		Image tmpImg = xmlLoader.getImage(imageName);
		ImageData imgData = xmlLoader.getImageData(imageName);
		Dimension2D targetDim = new Dimension2D(newWidth, controlHeight);
		ImageScaleState state = new ImageScaleState(new Dimension2D(tmpImg.getWidth(), tmpImg.getHeight()), targetDim, imgData.getCrop(), imgData.getMaxCrop());
		ImageView tmpImgView = imageUtils.cropAndScale(imageName, state);
		imgView.setImageView(newWidth, controlHeight, tmpImgView, state);
		List<Polygon> polygons = polygonInitFactory.getScenePolygonInitializer().initialzePolygons(state);
		imgView.resetPolygons(polygons);
		placeHolder.setWidth(newWidth);
		this.controlWidth = newWidth;
	}


	public void heightChange(double oldHeight, double newHeigth) {
		String imageName = getImageNameFromScene();
		Image tmpImg = xmlLoader.getImage(imageName);
		ImageData imgData = xmlLoader.getImageData(imageName);
		Dimension2D targetDim = new Dimension2D(controlWidth, newHeigth);
		ImageScaleState state = new ImageScaleState(new Dimension2D(tmpImg.getWidth(), tmpImg.getHeight()), targetDim, imgData.getCrop(), imgData.getMaxCrop());
		ImageView tmpImgView = imageUtils.cropAndScale(imageName, state);
		imgView.setImageView(controlWidth, newHeigth, tmpImgView, state);
		List<Polygon> polygons = polygonInitFactory.getScenePolygonInitializer().initialzePolygons(state);
		imgView.resetPolygons(polygons);
		placeHolder.setHeight(newHeigth);
		this.controlHeight = newHeigth;
	}
    @Subscribe
    public void handleViewChange(ViewChangeEvent event) {
        if (event.getAddresse().equals(MainGameView.class)) {
            sceneEventHandlerFactory.getSceneEventHandler().handleEvent(event.getEventNotice());
        }
    }

    /**
     * Replace the current dialog with a new one.
     * @param dialogType
     */
    @Override
    public void replaceDialog(EDialogType dialogType) {
        closeDialog();
        setNewDialog(dialogType);
    }

    /**
     * Close the currently open dialog
     */
    @Override
    @DialogCloseing
    public void closeDialog() {
        Platform.runLater(new Runnable() {
            @Override
            public void run() {
                getChildren().remove(dialog);
                dialogScope.closeScope();
            }
        });
    }

    /**
     * Set up the new dialog.
     * @param dialogType
     */
    @Override
    @DialogOpening
    public void setNewDialog(EDialogType dialogType) {
        dialogScope.openScope();
        dialog = dialogFactory.getDialog(dialogType, viewState.getCurrentCityProxy().get());
        dialog.setLayoutX((controlWidth - Dialog.WIDTH) / 2);
        dialog.setLayoutY((controlHeight - Dialog.HEIGHT) / 2);
        Platform.runLater(new Runnable() {
            @Override
            public void run() {
                getChildren().add(dialog);
            }
        });
    }

    /**
     * Change the scene image
     */
    @Override
    public void changeScene() {
        Platform.runLater(new Runnable() {
            @Override
            public void run() {
                closeDialog();
                stack.getChildren().removeAll(imgView);
                setUpImageView();
                stack.getChildren().add(imgView);
            }
        });
     }

}
