package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 12, 2013
 */
@Service
public class SceneEventHandlerFactory {
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty<>(this, "currentScene", EScene.PORT);
    @Autowired
    private PortSceneEventHandler portSceneHandler;
    @Autowired
    private MarketSceneEventHandler marketSceneHandler;
    @Autowired
    private ShipyardSceneEventHandler shipyardSceneHandler;
    @Autowired
    private TavernSceneEventHandler tavernSceneHandler;
    @Autowired
    private CityHallSceneEventHandler cityHallSceneEventHandler;
    @Autowired
    private LoanerSceneEventHandler loanerSceneEventHandler;
    @PostConstruct
    private void initializeBinding() {
        portSceneHandler.currentSceneProperty().bindBidirectional(currentScene);
        marketSceneHandler.currentSceneProperty().bindBidirectional(currentScene);
        shipyardSceneHandler.currentSceneProperty().bindBidirectional(currentScene);
        tavernSceneHandler.currentSceneProperty().bindBidirectional(currentScene);
        cityHallSceneEventHandler.currentSceneProperty().bindBidirectional(currentScene);
        loanerSceneEventHandler.currentSceneProperty().bindBidirectional(currentScene);
    }
    public ObjectProperty<EScene> currentSceneProperty() {
        return currentScene;
    }

    public void setUpDialogController(IDialogContoller controller){
        portSceneHandler.setDialogContoller(controller);
        marketSceneHandler.setDialogContoller(controller);
        shipyardSceneHandler.setDialogContoller(controller);
        tavernSceneHandler.setDialogContoller(controller);
        cityHallSceneEventHandler.setDialogContoller(controller);
        loanerSceneEventHandler.setDialogContoller(controller);
    }

    public ISceneEventHandler getSceneEventHandler() {
        switch (currentScene.get()) {
            case PORT:
                return portSceneHandler;
            case MARKET:
                return marketSceneHandler;
            case SHIPYARD:
                return shipyardSceneHandler;
            case TAVERN:
                return tavernSceneHandler;
            case CITY_HALL:
                return cityHallSceneEventHandler;
            case LOANER:
                return loanerSceneEventHandler;
            default:
                throw new IllegalStateException("Unsupported scene: "+currentScene.get());
        }
    }
}
