package ch.sahits.game.javafx.control;

import ch.sahits.game.graphic.display.OpenPaticianApplicationWindow;
import ch.sahits.game.graphic.display.SceneChangeable;
import ch.sahits.game.graphic.display.scene.InGameOptionsScene;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.util.UIFactory;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;

/**
 * Control representing the main menu.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 1, 2013
 *
 */
public class MainMenu extends Group {
	@Autowired
	@Qualifier("mainScreenXMLImageLoader")
	private IDataImageLoader imageLoader;
	@Autowired
	private UIFactory uiFactory;

	private SceneChangeable sceneChangeable;
	public MainMenu() {
		setManaged(false);
	}
	@PostConstruct
	private void initializeControls() {
		sceneChangeable = OpenPaticianApplicationWindow.getApplication();
		HBox iconBar = new HBox(3);
		final ImageView options = new ImageView(imageLoader.getImage("icons/64/anchor"));
		options.setScaleX(0.5);
		options.setScaleY(0.5);
		options.setOnMouseReleased(new EventHandler<MouseEvent>() {
			@Override
			public void handle(MouseEvent mouseEvent) {
				Scene currentScene = getScene();
				InGameOptionsScene options = uiFactory.getInGameOptionsScene(currentScene.getWidth(), currentScene.getHeight());
				options.setSceneChangeable(sceneChangeable);
				sceneChangeable.changeScene(options);

			}
		});
		TransparentImageViewClickableArea optionClick = new TransparentImageViewClickableArea(options);
		iconBar.getChildren().addAll(options, optionClick);
		iconBar.setLayoutX(-12); // this is due to the scaling, the bounds do not change.
		iconBar.setLayoutY(-12);
		getChildren().addAll(iconBar);

	}
}
