package ch.sahits.game.javafx.control;

import ch.sahits.game.event.data.NewGameClient;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.image.IImageUtilities;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.IMap;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;

/**
 * Mini map control
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 1, 2013
 *
 */
@LazySingleton
public class MiniMap extends Group {
    @Autowired
    private IMap map;
    @Autowired
    private IImageUtilities imageUtilities;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    private ImageView imgView;

    @PostConstruct
    private void initializeControl() {
        clientServerEventBus.register(this);
        setManaged(false);
        imgView = new ImageView();
        imgView.setFitWidth(236);
        imgView.setFitHeight(192);
        imgView.setPreserveRatio(false);
        // scale the map to the correct size add white dots on cities that have ship in them
        // clicking on the city changes into the other city (if there is a ship or kontor
        // right clicking on a point on the map sends the active ship to that location
        getChildren().addAll(imgView);
    }

    /**
     * Initialize the player that goes with this client. The player does not change later on,
     * @param newGameDTO
     */
    @Subscribe
    public void initializeState(NewGameClient newGameDTO) {
        Image mapImage = imageUtilities.createMapWithCities(map, newGameDTO.getPlayer());
        mapImage =  imageUtilities.createImageWithShipsInCities(map, newGameDTO.getPlayer(), mapImage);
        Dimension2D dim = map.getDimension();
        double factor = 192 / dim.getHeight();
        double widthOrigImg = 236 / factor;
        double xlocation = newGameDTO.getPlayer().getHometown().getCoordinates().getX();
        double x = Math.max(0, xlocation - widthOrigImg/2);
        Rectangle2D viewport = new Rectangle2D(x, 0, widthOrigImg, dim.getHeight());

        imgView.setViewport(viewport);
        imgView.setImage(mapImage);
    }
}
