/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game;

import ch.sahits.game.openpatrician.util.GamePropertyUtility;
import com.google.common.base.Preconditions;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CommandLineArguments {
    static final String VERSION_OPTION = "version";
    static final String HELP_OPTION = "h";
    private static final String WINDOWED_MODE = "w";
    private static final String FULLSCREEN_MODE = "f";
    public static final String CLIENT_OPTION = "c";
    public static final String SERVER_OPTION = "s";
    private CommandLineParser parser = new PosixParser();
    private GamePropertyUtility gameProperties = new GamePropertyUtility();

    public Options createCommandLineOptions() {
        Options opts = new Options();
        opts.addOption(HELP_OPTION, "help", false, "Display help");
        OptionBuilder.withLongOpt((String)VERSION_OPTION);
        OptionBuilder.withDescription((String)"Version of this application");
        opts.addOption(OptionBuilder.create());
        opts.addOption(FULLSCREEN_MODE, "fullscreen", false, "fullscreen mode");
        OptionBuilder.withArgName((String)WINDOWED_MODE);
        OptionBuilder.withLongOpt((String)"windowed");
        OptionBuilder.hasOptionalArgs((int)1);
        OptionBuilder.withArgName((String)"widthxheight");
        OptionBuilder.withDescription((String)"Windowed mode with optional definition of window size like: 1280x780");
        opts.addOption(OptionBuilder.create());
        opts.addOption(CLIENT_OPTION, "client", false, "Start application in client mode. Currently currently unused. Either client or server must be specified");
        opts.addOption(SERVER_OPTION, "server", false, "Start application in server mode. Currently currently unused. Either client or server must be specified");
        return opts;
    }

    public CommandLine parseCommandLine(Options options, String[] args) {
        try {
            return this.parser.parse(options, args);
        }
        catch (ParseException exp) {
            this.printHelp(options);
            throw new IllegalArgumentException("Parsing of command line arguments failed", exp);
        }
    }

    public void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("OpenPatrician", options);
    }

    public boolean isStandalone(CommandLine cmdLine) {
        return !cmdLine.hasOption(CLIENT_OPTION) && !cmdLine.hasOption(SERVER_OPTION) || cmdLine.hasOption(CLIENT_OPTION) && cmdLine.hasOption(SERVER_OPTION);
    }

    public boolean isServer(CommandLine cmdLine) {
        return !this.isStandalone(cmdLine) && cmdLine.hasOption(SERVER_OPTION);
    }

    public boolean isClient(CommandLine cmdLine) {
        return !this.isStandalone(cmdLine) && cmdLine.hasOption(CLIENT_OPTION);
    }

    public void persistAsPropertyFile(CommandLine cmdLine) {
        Properties props = this.gameProperties.getProperties();
        if (this.isStandalone(cmdLine)) {
            this.gameProperties.addSpringProfile("standalone");
        } else if (cmdLine.hasOption(CLIENT_OPTION)) {
            this.gameProperties.addSpringProfile("client");
        } else if (cmdLine.hasOption(SERVER_OPTION)) {
            this.gameProperties.addSpringProfile("server");
        }
        if (cmdLine.hasOption(FULLSCREEN_MODE)) {
            props.setProperty("window.fullscreen", "true");
        } else {
            props.setProperty("window.fullscreen", "false");
        }
        if (cmdLine.hasOption(WINDOWED_MODE)) {
            props.setProperty("window.fullscreen", "false");
            String windowedOption = cmdLine.getOptionValue(WINDOWED_MODE);
            if (windowedOption != null) {
                String[] values = windowedOption.split("x");
                try {
                    Integer.parseInt(values[0]);
                    Integer.parseInt(values[1]);
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("The window size parameter is invalid: " + windowedOption);
                }
                props.setProperty("window.width", values[0]);
                props.setProperty("window.height", values[1]);
            }
        }
        int height = Integer.parseInt((String)props.get("window.height"));
        this.checkMinimalHeight(height);
        this.gameProperties.persistProperties();
    }

    private void checkMinimalHeight(int height) {
        Preconditions.checkArgument((height >= 766 ? 1 : 0) != 0, (Object)"The frame in the display must have at least 766px height");
    }
}

