/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.handler;

import ch.sahits.game.event.data.NewGameClient;
import ch.sahits.game.javafx.control.GameStatus;
import ch.sahits.game.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
public class StartNewGameHandler {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private GameStatus gameStatus;
    @Autowired
    private ViewStatus viewStatus;

    @PostConstruct
    private void initializeEventSystem() {
        this.clientServerEventBus.register((Object)this);
    }

    @Subscribe
    public void handleNewGameStart(NewGameClient newGameDTO) {
        this.gameStatus.bindToPlayer(newGameDTO.getPlayer());
        this.viewStatus.setCity(newGameDTO.getPlayer().getHometown().getName());
    }
}

