/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.handler.impl.WaitTimeForShipArrivalInCity;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
class DeliverPackages
extends WaitTimeForShipArrivalInCity {
    private final int amount;
    private final int premium;
    @Autowired
    private Random rnd;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public DeliverPackages(ICity city, IShip ship, DateTime deadline, int premium, int amount) {
        super(city, ship, deadline);
        this.premium = premium;
        this.amount = amount;
    }

    @PostConstruct
    private void initializeEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    public boolean execute() {
        this.getShip().setOccupiedSpace(this.getShip().getOccupiedSpace() - this.amount);
        IPlayer owner = this.getShip().getOwner();
        if (this.rnd.nextBoolean()) {
            int penalty = (int)Math.abs((double)(owner.getCash() / 200L) * this.rnd.nextDouble());
            String s = this.messageSource.getMessage("ch.sahits.game.event.handler.impl.DeliverPackages.messageCaught", new Object[]{penalty}, this.locale.getCurrentLocal());
            DisplayMessage msg = new DisplayMessage(s, this.messageSource.getMessage("ch.sahits.game.graphic.event.task.DelayedCaughtAction.message2", new Object[]{penalty}, this.locale.getCurrentLocal()));
            this.clientEventBus.post((Object)msg);
            owner.getCompany().updateCash((long)(-penalty));
        } else {
            owner.getCompany().updateCash((long)this.premium);
            DisplayMessage msg = new DisplayMessage(this.messageSource.getMessage("ch.sahits.game.event.handler.impl.DeliverPackages.messageSuccess", new Object[0], this.locale.getCurrentLocal()));
            this.clientEventBus.post((Object)msg);
        }
        return false;
    }

    @Override
    public void destroy() {
        this.getShip().setOccupiedSpace(this.getShip().getOccupiedSpace() - this.amount);
        super.destroy();
    }
}

