/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.handler.impl;

import ch.sahits.game.graphic.display.dialog.ClosableDialog;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.base.Optional;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Random;
import javafx.beans.property.ObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
public class HirePirateEventHandler
implements EventHandler<MouseEvent> {
    private final ObjectProperty<IShip> currentShip;
    private final ICityPlayerProxyJFX city;
    private final IPirate pirate;
    private final ClosableDialog delegateDialog;
    @Autowired
    private SeaPiratesState seaPiratesState;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public HirePirateEventHandler(ObjectProperty<IShip> currentShip, ICityPlayerProxyJFX city, IPirate pirate, ClosableDialog delegateDialog) {
        this.currentShip = currentShip;
        this.city = city;
        this.pirate = pirate;
        this.delegateDialog = delegateDialog;
    }

    public void handle(MouseEvent mouseEvent) {
        final ISeaPirate seaPirate = this.seaPiratesState.createNewPirate(this.pirate.getName(), (IShip)this.currentShip.get(), this.city.getCity().getCoordinates());
        this.seaPiratesState.add(seaPirate, Optional.of((Object)this.city.getPlayer()));
        int nbDays = this.rnd.nextInt(200) + 30;
        DateTime deadline = this.date.getCurrentDate().plus((long)nbDays);
        TimedTask task = new TimedTask(){

            public void run() {
                HirePirateEventHandler.this.seaPiratesState.free(HirePirateEventHandler.this.city.getPlayer(), seaPirate);
            }
        };
        task.setExecutionTime(deadline);
        this.timedTaskListener.add(task);
        this.city.getPlayer().removeShip((IShip)this.currentShip.get());
        this.pirate.leave();
        int caughtProb = this.rnd.nextInt(3);
        if (caughtProb == 1) {
            deadline = this.date.getCurrentDate().plus(5L);
            final int fine = (int)Math.abs((double)(this.city.getPlayer().getCash() / 200L) * this.rnd.nextDouble());
            task = new TimedTask(){

                public void run() {
                    DisplayMessage msg = new DisplayMessage(HirePirateEventHandler.this.messageSource.getMessage("ch.sahits.game.event.handler.impl.HirePirateEventHandler.fineMessage1", new Object[]{fine}, HirePirateEventHandler.this.locale.getCurrentLocal()), HirePirateEventHandler.this.messageSource.getMessage("ch.sahits.game.event.handler.impl.HirePirateEventHandler.fineMessage2", new Object[0], HirePirateEventHandler.this.locale.getCurrentLocal()));
                    HirePirateEventHandler.this.clientEventBus.post((Object)msg);
                    HirePirateEventHandler.this.city.getPlayer().updateCash(-fine);
                }
            };
            task.setExecutionTime(deadline);
            this.timedTaskListener.add(task);
        }
        this.delegateDialog.executeOnCloseButtonClicked();
    }
}

