/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.ShipEntersPortEvent;
import ch.sahits.game.event.data.PatrolInternalState;
import ch.sahits.game.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.event.handler.impl.AttackListener;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.base.Optional;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
class NextPatrolStation
extends ShipEntersPortEventListener {
    private final PatrolInternalState state;
    private final IPlayer player;
    private final DateTime deadline;
    private final AttackListener atackListener;
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Date date;
    @Autowired
    private Random rnd;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public NextPatrolStation(IShip ship, ICity city, PatrolInternalState state, IPlayer player, DateTime deadline, AttackListener atackListener) {
        super(ship, city);
        this.state = state;
        this.player = player;
        this.deadline = deadline;
        this.atackListener = atackListener;
        state.removeFirstCity();
    }

    @PostConstruct
    private void initEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    public void handleShipEntersPort(ShipEntersPortEvent event) {
        super.handleShipEntersPort(event);
        DateTime now = this.date.getCurrentDate();
        if (now.isAfter((ReadableInstant)this.deadline)) {
            this.clientEventBus.post((Object)new DisplayMessage(this.messageSource.getMessage("ch.sahits.game.event.handler.impl.NextCourierPatrolStation.unreliable", new Object[0], this.locale.getCurrentLocal())));
            this.clientServerEventBus.unregister((Object)this);
            this.clientServerEventBus.unregister((Object)this.atackListener);
        }
    }

    public boolean execute() {
        Optional<ICity> nextCity = this.state.nextDestination();
        if (!nextCity.isPresent()) {
            int premium = this.state.getPremium() + this.state.getNumberOfAttacks() * this.state.getBonusPerAttack();
            this.player.updateCash(premium);
            this.clientEventBus.post((Object)new DisplayMessage(this.messageSource.getMessage("ch.sahits.game.event.handler.impl.NextPatrolStation.premium", new Object[]{premium}, this.locale.getCurrentLocal())));
            this.clientServerEventBus.unregister((Object)this.atackListener);
        } else {
            ICity next = (ICity)nextCity.get();
            this.state.removeFirstCity();
            int minutes = this.rnd.nextInt(600);
            DateTime postMessage = this.date.getCurrentDate().plusMinutes(minutes);
            String message = this.messageSource.getMessage("ch.sahits.game.event.handler.impl.NextCourierPatrolStation.nextStation", new Object[]{next.getName()}, this.locale.getCurrentLocal());
            this.taskFactory.getPostponedDisplayMessage(postMessage, message);
            DateTime deadline = this.date.getCurrentDate().plusDays(6);
            new NextPatrolStation(this.getShip(), (ICity)this.state.nextDestination().get(), this.state, this.player, deadline, this.atackListener);
        }
        return true;
    }
}

