/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.event.handler.impl.WaitTimeForShipArrival;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
class ShipArrivalForLoading
extends WaitTimeForShipArrival {
    private final int requiredAmount;
    private final int premium;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;

    public ShipArrivalForLoading(ICity city, IPlayer player, DateTime deadline, int requiredAmount, int premium) {
        super(city, player, deadline);
        this.requiredAmount = requiredAmount;
        this.premium = premium;
    }

    @PostConstruct
    private void initializeEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    public boolean execute() {
        if (ShipArrivalForLoading.hasShipEnoughCapacity(this.getShip(), this.requiredAmount)) {
            this.getShip().setOccupiedSpace(this.requiredAmount + this.getShip().getOccupiedSpace());
            DateTime waitTenDays = this.getDate().getCurrentDate().plusDays(10);
            this.eventHandlerFactory.getDeliverPackagesHandler(this.getCity(), this.getShip(), waitTenDays, this.premium, this.requiredAmount);
            return true;
        }
        return false;
    }

    private static boolean hasShipEnoughCapacity(IShip ship, int requiredAmount) {
        return ship.getCapacity() > requiredAmount;
    }
}

