/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.ShipAttackEvent;
import ch.sahits.game.event.handler.TimedEventListener;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
public class SinkConcurrentsShipOrder
extends TimedEventListener {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    private final IPlayer opponent;
    private final IPlayer player;
    private final int premium;
    private final TimedTask reconciliation;
    private final int offeredTime;
    @Autowired
    private TimedUpdatableTaskList list;

    public SinkConcurrentsShipOrder(IPlayer opponent, IPlayer player, int offerdTime, int premium, TimedTask reconciliation) {
        this.offeredTime = offerdTime;
        this.opponent = opponent;
        this.player = player;
        this.premium = premium;
        this.reconciliation = reconciliation;
    }

    @PostConstruct
    private void initialize() {
        this.setDeadline(this.date.getCurrentDate().plusDays(this.offeredTime));
        this.clientServerEventBus.register((Object)this);
    }

    @Subscribe
    public void handleShipAttack(ShipAttackEvent event) {
        if (this.deadline.isAfter((ReadableInstant)this.date.getCurrentDate())) {
            IPlayer attackedOwner = event.getAttackedShip().getOwner();
            IPlayer attackingOwner = event.getAttackingShip().getOwner();
            if (attackedOwner != null && attackedOwner.equals(this.opponent) && attackingOwner != null && attackingOwner.equals(this.player)) {
                this.execute();
                this.clientServerEventBus.unregister((Object)this);
            }
        } else {
            this.destroy();
            this.clientServerEventBus.unregister((Object)this);
        }
    }

    public boolean execute() {
        this.clientEventBus.post((Object)new DisplayMessage(this.messageSource.getMessage("ch.sahits.game.event.handler.impl.SinkConcurrentsShipOrder.thankyou", new Object[0], this.locale.getCurrentLocal())));
        this.player.updateCash(this.premium);
        if (this.reconciliation != null) {
            this.list.remove(this.reconciliation);
        }
        return true;
    }
}

