/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.model.people.ISailors;
import ch.sahits.game.openpatrician.model.people.ITrader;
import ch.sahits.game.openpatrician.model.people.ITraveler;
import ch.sahits.game.openpatrician.model.people.IWeaponsDealer;
import com.google.common.eventbus.AsyncEventBus;
import javafx.collections.ObservableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
class TavernDialogChangeAction
implements Runnable {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    private final IPerson showingPerson;
    private final TavernState tavernState;
    private final IPlayer player;

    public TavernDialogChangeAction(IPerson showingPerson, TavernState tavernState, IPlayer currentPlayer) {
        this.showingPerson = showingPerson;
        this.tavernState = tavernState;
        this.player = currentPlayer;
    }

    @Override
    public void run() {
        boolean doUpdate = false;
        ENoticeItem selected = null;
        boolean canTalkToOnlyOnePerson = true;
        if (this.showingPerson instanceof IBuyer) {
            selected = ENoticeItem.TAVERN_BUYER;
            doUpdate = true;
        }
        if (this.showingPerson instanceof ISailors) {
            selected = ENoticeItem.TAVERN_SAILORS;
            doUpdate = true;
            canTalkToOnlyOnePerson = false;
        }
        if (this.showingPerson instanceof IWeaponsDealer) {
            selected = ENoticeItem.TAVERN_WEAPONS_DEALER;
            doUpdate = true;
            canTalkToOnlyOnePerson = false;
        }
        if (this.showingPerson instanceof IInformant) {
            selected = ENoticeItem.TAVERN_INFORMANT_1;
            doUpdate = true;
        }
        if (this.showingPerson instanceof ICaptain) {
            selected = ENoticeItem.TAVERN_CAPTAIN;
            doUpdate = true;
        }
        if (this.showingPerson instanceof IPirate) {
            selected = ENoticeItem.TAVERN_PIRATE;
            doUpdate = true;
        }
        if (this.showingPerson instanceof ITraveler) {
            selected = ENoticeItem.TAVERN_TRAVELER;
            doUpdate = true;
        }
        if (this.showingPerson instanceof ITrader) {
            selected = ENoticeItem.TAVERN_TRADER;
            doUpdate = true;
        }
        if (doUpdate) {
            if (canTalkToOnlyOnePerson) {
                ((ObservableMap)this.tavernState.talkingToProperty().get()).put((Object)this.showingPerson, (Object)this.player);
            }
            this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)selected));
        }
    }
}

