/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display;

import ch.sahits.game.event.data.NewGameClient;
import ch.sahits.game.graphic.display.EViewState;
import ch.sahits.game.graphic.display.model.CityPlayerProxyJFX;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.base.Optional;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ClientViewState {
    private EViewState state;
    private Optional<ICityPlayerProxyJFX> currentCityProxy;
    private IPlayer player;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    @PostConstruct
    private void initEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @Subscribe
    public void initializeState(NewGameClient newGameDTO) {
        this.player = newGameDTO.getPlayer();
        this.state = EViewState.CITY;
        IShip activeShip = null;
        for (IShip ship : this.player.getFleet()) {
            if (!ship.isAvailable()) continue;
            activeShip = ship;
            break;
        }
        CityPlayerProxyJFX proxy = new CityPlayerProxyJFX(this.player.getHometown(), this.player, activeShip);
        this.currentCityProxy = Optional.of((Object)proxy);
    }

    public EViewState getState() {
        return this.state;
    }

    public Optional<ICityPlayerProxyJFX> getCurrentCityProxy() {
        return this.currentCityProxy;
    }

    public IPlayer getPlayer() {
        return this.player;
    }
}

