/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display;

import ch.sahits.game.event.EGameStatusChange;
import ch.sahits.game.event.GameStateChange;
import ch.sahits.game.graphic.display.SceneChangeable;
import ch.sahits.game.graphic.display.scene.StartupScene;
import ch.sahits.game.javafx.OpenPatricianScene;
import ch.sahits.game.javafx.event.AggregateEventHandler;
import ch.sahits.game.javafx.event.CloseApplicationEventHandler;
import ch.sahits.game.javafx.event.MouseClickLocationEventHandler;
import ch.sahits.game.openpatrician.server.ServerLauncher;
import ch.sahits.game.openpatrician.util.GamePropertyUtility;
import ch.sahits.game.util.UIFactory;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public final class OpenPaticianApplicationWindow
extends Application
implements SceneChangeable {
    private final Logger logger = Logger.getLogger(this.getClass());
    private GamePropertyUtility gamePropertyUtility;
    private final int minWidth;
    private final int minHeight;
    private int width;
    private int height;
    private boolean fullscreen;
    private Stage primaryStage;
    private final AggregateEventHandler<KeyEvent> keyEventHandlerAggregate;
    private final MouseClickLocationEventHandler mouseClickEventHandler;
    private static OpenPaticianApplicationWindow instance;
    private ApplicationContext context;

    public OpenPaticianApplicationWindow() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Application should only be initialized once.");
        this.minHeight = 766;
        this.width = this.minWidth = 1074;
        this.height = this.minHeight;
        this.fullscreen = false;
        this.keyEventHandlerAggregate = new AggregateEventHandler();
        CloseApplicationEventHandler closeEventHandler = new CloseApplicationEventHandler();
        this.mouseClickEventHandler = new MouseClickLocationEventHandler();
        EventHandler<KeyEvent> fullScreenEventHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.F) && event.isControlDown()) {
                    OpenPaticianApplicationWindow.this.updateFullscreenMode();
                }
            }
        };
        this.keyEventHandlerAggregate.addEventHandler((EventHandler)closeEventHandler);
        this.keyEventHandlerAggregate.addEventHandler((EventHandler)fullScreenEventHandler);
        instance = this;
    }

    public static SceneChangeable getApplication() {
        return instance;
    }

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        this.primaryStage.setMinWidth((double)this.minWidth);
        this.primaryStage.setMinHeight((double)this.minHeight);
        this.context = ServerLauncher.getClientServerContext();
        UIFactory uiFactory = (UIFactory)this.context.getBean(UIFactory.class);
        StartupScene startupS = uiFactory.getStartupScene(this.width, this.height);
        this.gamePropertyUtility = (GamePropertyUtility)this.context.getBean(GamePropertyUtility.class);
        this.fullscreen = Boolean.valueOf((String)this.gamePropertyUtility.getProperties().get("window.fullscreen"));
        startupS.setSceneChangeable(this);
        startupS.setOnMousePressed((EventHandler)this.mouseClickEventHandler);
        startupS.setOnKeyPressed((EventHandler)this.keyEventHandlerAggregate);
        primaryStage.setFullScreen(this.fullscreen);
        primaryStage.setTitle("OpenPatrician");
        primaryStage.setScene((Scene)startupS);
        primaryStage.show();
    }

    @Override
    public void changeScene(OpenPatricianScene scene) {
        scene.setOnMousePressed((EventHandler)this.mouseClickEventHandler);
        scene.setOnKeyPressed(this.keyEventHandlerAggregate);
        this.primaryStage.setScene((Scene)scene);
    }

    public void updateFullscreenMode() {
        this.fullscreen = !this.fullscreen;
        this.primaryStage.setFullScreen(this.fullscreen);
    }

    public static void startClientUI(String[] args) {
        OpenPaticianApplicationWindow.launch((String[])args);
    }

    @Override
    public double getSceneWidth() {
        return this.primaryStage.getScene().getWidth();
    }

    @Override
    public double getSceneHeight() {
        return this.primaryStage.getScene().getHeight();
    }

    public void stop() throws Exception {
        System.out.println("Stopping the UI Application");
        this.stopUIApplicationContext();
        super.stop();
    }

    private void stopUIApplicationContext() {
        AsyncEventBus eventBus = (AsyncEventBus)this.context.getBean("serverClientEventBus");
        eventBus.post((Object)new GameStateChange(EGameStatusChange.SHUTDOWN));
        ((AbstractApplicationContext)this.context).close();
    }
}

